/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.registries.ForgeRegistries;

public class NetherBeehiveDecorator
extends TreeDecorator {
    public static final Codec<NetherBeehiveDecorator> CODEC = RecordCodecBuilder.create(configurationInstance -> configurationInstance.group((App)Codec.FLOAT.fieldOf("probability").orElse((Object)Float.valueOf(0.0f)).forGetter(configuration -> Float.valueOf(configuration.probability))).apply((Applicative)configurationInstance, NetherBeehiveDecorator::new));
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != Direction.SOUTH.m_122424_()).toArray(Direction[]::new);
    private float probability = 0.0f;
    private BlockState nest;

    public NetherBeehiveDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ModFeatures.NETHER_BEEHIVE.get();
    }

    public void setNest(BlockState nest) {
        this.nest = nest;
    }

    public void m_214187_(TreeDecorator.Context context) {
        if (this.probability == 0.0f) {
            this.probability = ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("nether_bee_nest").get()).floatValue();
        }
        if (!(context.m_226067_().m_188501_() >= this.probability) && this.nest != null) {
            if (context.m_226069_().isEmpty() || context.m_226068_().isEmpty()) {
                return;
            }
            int i = Math.max(((BlockPos)context.m_226069_().get(0)).m_123342_() - 1, ((BlockPos)context.m_226068_().get(0)).m_123342_() + 1);
            List list = context.m_226068_().stream().filter(pos -> pos.m_123342_() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0))).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Collections.shuffle(list);
                Optional<BlockPos> optional = list.stream().filter(pos -> context.m_226059_(pos) && context.m_226059_(pos.m_121945_(Direction.SOUTH))).findFirst();
                if (optional.isPresent()) {
                    Direction facing = Direction.SOUTH;
                    for (Direction d : Direction.Plane.HORIZONTAL) {
                        if (!context.m_226068_().contains((Object)optional.get().m_121945_(d))) continue;
                        facing = d.m_122424_();
                        break;
                    }
                    context.m_226061_(optional.get(), (BlockState)this.nest.m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)facing));
                    context.m_226058_().m_141902_(optional.get(), (BlockEntityType)ModBlockEntityTypes.NETHER_BEE_NEST.get()).ifPresent(blockEntity -> {
                        int j = 2 + context.m_226067_().m_188503_(2);
                        String type = ForgeRegistries.BLOCKS.getKey((Object)this.nest.m_60734_()).m_135815_().equals("warped_bee_nest") ? "warped" : "crimson";
                        for (int k = 0; k < j; ++k) {
                            try {
                                Supplier<BeeIngredient> beeIngredient = BeeIngredientFactory.getIngredient("productivebees:" + type);
                                if (beeIngredient.get() == null) continue;
                                CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient.get());
                                blockEntity.addBee(bee, context.m_226067_().m_188503_(599), 600, null, Component.m_237115_((String)("entity.productivebees." + type + "_bee")).getString());
                                continue;
                            }
                            catch (CommandSyntaxException e) {
                                ProductiveBees.LOGGER.warn("Failed to put bees into nether nest :(" + e.getMessage());
                            }
                        }
                    });
                }
            }
        }
    }
}

