/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.nodes;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.rebornstorage.Constants;
import net.gigabit101.rebornstorage.RebornStorageConfig;
import net.gigabit101.rebornstorage.RebornStorageEventHandler;
import net.gigabit101.rebornstorage.blockentities.BlockEntityMultiCrafter;
import net.gigabit101.rebornstorage.init.ModBlocks;
import net.gigabit101.rebornstorage.multiblocks.MultiBlockCrafter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CraftingNode
extends NetworkNode
implements ICraftingPatternContainer {
    Level world;
    BlockPos pos;
    List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    @Nullable
    INetwork network;
    int ticks = 0;
    private UUID uuid;
    private boolean needsRebuild = false;
    private boolean isValid;
    private int speed = -1;
    public static int craftingSpeed = 5;
    public static int invUpdateTime = 5;
    public CachingItemHandler patterns = new CachingItemHandler(78){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (CraftingNode.this.network != null) {
                CraftingNode.this.markDirty();
            }
            CraftingNode.this.needsRebuild = true;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public CraftingNode(Level level, BlockPos pos) {
        super(level, pos);
        this.world = level;
        this.pos = pos;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public void rebuildPatterns(String reason) {
        this.actualPatterns.clear();
        if (!this.world.f_46443_ && this.isValidMultiBlock(true)) {
            if (!this.patterns.isEmpty()) {
                for (int i = 0; i < this.patterns.getSlots(); ++i) {
                    ItemStack stack = this.patterns.getStackInSlot(i);
                    if (!stack.m_41619_() && stack.m_41720_() instanceof ICraftingPatternProvider) {
                        if (this.patterns.craftingPatternMap.containsKey(i)) {
                            this.actualPatterns.add(this.patterns.craftingPatternMap.get(i));
                            continue;
                        }
                        ICraftingPattern pattern = ((ICraftingPatternProvider)stack.m_41720_()).create(this.world, stack, (ICraftingPatternContainer)this);
                        if (!pattern.isValid()) continue;
                        this.actualPatterns.add(pattern);
                        this.patterns.craftingPatternMap.put(i, pattern);
                        continue;
                    }
                    this.patterns.craftingPatternMap.remove(i);
                }
            } else {
                this.patterns.craftingPatternMap.clear();
            }
        }
        if (this.getNetwork() != null) {
            RebornStorageEventHandler.queue(this.network.getCraftingManager(), this, reason);
        }
    }

    public void stateChange(INetwork network, boolean state, String reason) {
        if (!state) {
            network.getCraftingManager().getTasks().forEach(task -> network.getCraftingManager().cancel(task.getId()));
            this.actualPatterns.clear();
        }
        RebornStorageEventHandler.queue(network.getCraftingManager(), this, reason);
    }

    @Nullable
    public BlockEntityMultiCrafter getTile() {
        BlockEntity tileEntity = this.world.m_7702_(this.pos);
        if (tileEntity instanceof BlockEntityMultiCrafter) {
            return (BlockEntityMultiCrafter)tileEntity;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerLevel)this.level);
        manager.removeNode(this.getPos());
        return null;
    }

    public boolean isValidMultiBlock(boolean check) {
        if (!check && this.isValid) {
            return true;
        }
        BlockEntityMultiCrafter blockEntityMultiCrafter = this.getTile();
        if (blockEntityMultiCrafter == null) {
            return false;
        }
        MultiBlockCrafter multiBlockCrafter = this.getTile().getMultiBlock();
        if (multiBlockCrafter == null) {
            return false;
        }
        this.isValid = multiBlockCrafter.isAssembled();
        return this.isValid;
    }

    public int getEnergyUsage() {
        int max = 10000;
        if (this.getBlock() == null) {
            return 0;
        }
        if (this.getBlock() == ModBlocks.BLOCK_MULTI_FRAME.get()) {
            return (Integer)RebornStorageConfig.FRAME_COST.get();
        }
        if (this.getBlock() == ModBlocks.BLOCK_MULTI_HEAT.get()) {
            return (Integer)RebornStorageConfig.HEAT_COST.get();
        }
        if (this.getBlock() == ModBlocks.BLOCK_MULTI_CPU.get()) {
            return (Integer)RebornStorageConfig.CPU_COST.get();
        }
        if (this.getBlock() == ModBlocks.BLOCK_MULTI_STORAGE.get()) {
            return (Integer)RebornStorageConfig.STORAGE_COST.get();
        }
        return 0;
    }

    public Block getBlock() {
        if (this.getTile() == null) {
            return null;
        }
        return this.getTile().m_58900_().m_60734_();
    }

    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.getBlock());
    }

    public void onConnected(INetwork iNetwork) {
        this.network = iNetwork;
        this.stateChange(this.network, true, "connected to network");
        this.rebuildPatterns("connected to network");
    }

    public void onDisconnected(INetwork iNetwork) {
        this.network = null;
        this.actualPatterns.clear();
        this.stateChange(iNetwork, true, "disconnected from network");
    }

    public boolean isActive() {
        return this.isValid;
    }

    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    public void update() {
        super.update();
        ++this.ticks;
        if (this.ticks == 1) {
            this.rebuildPatterns("first tick rebuild");
        }
        if (this.needsRebuild && this.world.m_6106_().m_6793_() % (long)(invUpdateTime * 20) == 0L) {
            this.rebuildPatterns("inv slot change");
            this.needsRebuild = false;
        }
    }

    public CompoundTag write(CompoundTag nbtTagCompound) {
        StackUtils.writeItems((IItemHandler)this.patterns, (int)0, (CompoundTag)nbtTagCompound);
        return nbtTagCompound;
    }

    public void read(CompoundTag tag) {
        StackUtils.readItems((BaseItemHandler)this.patterns, (int)0, (CompoundTag)tag);
        super.read(tag);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getLevel() {
        return this.world;
    }

    public void markDirty() {
        if (this.world != null && !this.world.f_46443_) {
            try {
                INetworkNodeManager networkNodeManager = API.instance().getNetworkNodeManager((ServerLevel)this.world);
                if (networkNodeManager != null) {
                    networkNodeManager.markForSaving();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    public ResourceLocation getId() {
        return Constants.MULTI_BLOCK_ID;
    }

    public void setOwner(@Nullable UUID uuid) {
    }

    @Nullable
    public UUID getOwner() {
        return null;
    }

    public int getUpdateInterval() {
        return Math.max(craftingSpeed - this.getCraftingCpus(), 1);
    }

    public int getMaximumSuccessfulCraftingUpdates() {
        return Math.max(this.getCraftingCpus() / Math.max(craftingSpeed, 1), 1);
    }

    public int getCraftingCpus() {
        if (this.isValid && this.speed != -1) {
            return this.speed;
        }
        if (!this.isValidMultiBlock(false)) {
            return 0;
        }
        this.speed = this.getTile().getMultiBlock().speed;
        return this.speed;
    }

    public int getStorage() {
        if (!this.isValidMultiBlock(false)) {
            return 0;
        }
        return this.getTile().getMultiBlock().pages;
    }

    public IItemHandler getConnectedInventory() {
        return null;
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        return null;
    }

    public BlockEntity getConnectedBlockEntity() {
        return null;
    }

    public BlockEntity getFacingBlockEntity() {
        return null;
    }

    public Direction getDirection() {
        return null;
    }

    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    public IItemHandlerModifiable getPatternInventory() {
        if (this.isValidMultiBlock(true) && this.getTile() != null && this.getTile().m_58900_().m_60734_() == ModBlocks.BLOCK_MULTI_STORAGE.get()) {
            return this.patterns;
        }
        return null;
    }

    public Component getName() {
        return Component.m_237113_((String)"MultiBlock Crafter");
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        return null;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public void unlock() {
    }

    public abstract class CachingItemHandler
    extends BaseItemHandler {
        private int firstAvailable;
        private int lastUsed;
        protected HashMap<Integer, ICraftingPattern> craftingPatternMap;

        public CachingItemHandler(int size) {
            super(size);
            this.firstAvailable = 0;
            this.lastUsed = -1;
            this.craftingPatternMap = new HashMap();
        }

        protected void onLoad() {
            super.onLoad();
            this.firstAvailable = this.getSlots();
            this.lastUsed = -1;
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).m_41619_()) {
                    this.firstAvailable = Integer.min(this.firstAvailable, i);
                    continue;
                }
                this.lastUsed = Integer.max(this.lastUsed, i);
            }
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            int i = slot;
            while (i < this.firstAvailable && i >= 0 && this.getStackInSlot(i).m_41619_()) {
                this.firstAvailable = i--;
            }
            for (i = slot; i == this.firstAvailable && i < this.getSlots() && !this.getStackInSlot(i).m_41619_(); ++i) {
                this.firstAvailable = i + 1;
            }
            i = slot;
            while (i > this.lastUsed && i < this.getSlots() && !this.getStackInSlot(i).m_41619_()) {
                this.lastUsed = i++;
            }
            for (i = slot; i == this.lastUsed && i >= 0 && this.getStackInSlot(i).m_41619_(); --i) {
                this.lastUsed = i - 1;
            }
            this.craftingPatternMap.remove(slot);
        }

        public int getFirstAvailable() {
            return this.firstAvailable;
        }

        public int getLastUsed() {
            return this.lastUsed;
        }

        public boolean isEmpty() {
            return this.lastUsed == -1;
        }

        public boolean isFull() {
            return this.firstAvailable == this.getSlots();
        }
    }
}

