/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import reliquary.entities.LyssaHook;
import reliquary.init.ModItems;

public class LyssaHookRenderer
extends EntityRenderer<LyssaHook> {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType ENTITY_CUTOUT = RenderType.m_110452_((ResourceLocation)FISH_PARTICLES);

    public LyssaHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(LyssaHook entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        entity.getFishingPlayerOptional().ifPresent(player -> {
            float f3;
            double d6;
            double d5;
            double d4;
            matrixStack.m_85836_();
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85845_(this.f_114476_.m_114470_());
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            PoseStack.Pose pose1 = matrixStack.m_85850_();
            Matrix4f matrix4f = pose1.m_85861_();
            Matrix3f matrix3f = pose1.m_85864_();
            VertexConsumer vertexconsumer = buffer.m_6299_(ENTITY_CUTOUT);
            LyssaHookRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
            LyssaHookRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
            LyssaHookRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
            LyssaHookRenderer.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
            matrixStack.m_85849_();
            int i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.m_21205_();
            if (!itemstack.m_150930_((Item)ModItems.ROD_OF_LYSSA.get())) {
                i = -i;
            }
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            double d0 = Mth.m_14031_((float)f2);
            double d1 = Mth.m_14089_((float)f2);
            double d2 = (double)i * 0.35;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.525f, -0.1f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.5f);
                vec3 = vec3.m_82496_(-f1 * 0.7f);
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                d5 = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20192_();
            } else {
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.8;
                d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.8;
                f3 = player.m_6047_() ? -0.1875f : 0.0f;
            }
            double d9 = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
            double d10 = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.25;
            double d8 = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_173247_());
            PoseStack.Pose pose2 = matrixStack.m_85850_();
            for (int k = 0; k <= 16; ++k) {
                LyssaHookRenderer.stringVertex(f4, f5, f6, vertexconsumer1, pose2, LyssaHookRenderer.sixteenthOf(k), LyssaHookRenderer.sixteenthOf(k + 1));
            }
            matrixStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        });
    }

    private static float sixteenthOf(int number) {
        return (float)number / 16.0f;
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int packedLight, float x, int y, int u, int v) {
        vertexConsumer.m_85982_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float scale1, float scale2) {
        float f = x * scale1;
        float f1 = y * (scale1 * scale1 + scale1) * 0.5f + 0.25f;
        float f2 = z * scale1;
        float f3 = x * scale2 - f;
        float f4 = y * (scale2 * scale2 + scale2) * 0.5f + 0.25f - f1;
        float f5 = z * scale2 - f2;
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        vertexConsumer.m_85982_(pose.m_85861_(), f, f1, f2).m_6122_(0, 0, 0, 255).m_85977_(pose.m_85864_(), f3 /= f6, f4 /= f6, f5 /= f6).m_5752_();
    }

    public ResourceLocation getTextureLocation(LyssaHook entity) {
        return FISH_PARTICLES;
    }
}

