/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities;

import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.network.PacketFXThrownPotionImpact;
import reliquary.network.PacketHandler;
import reliquary.reference.Colors;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class GlowingWaterEntity
extends ThrowableProjectile
implements ItemSupplier {
    public GlowingWaterEntity(EntityType<GlowingWaterEntity> entityType, Level world) {
        super(entityType, world);
    }

    public GlowingWaterEntity(Level world, Player player) {
        super((EntityType)ModEntities.GLOWING_WATER.get(), (LivingEntity)player, world);
    }

    public GlowingWaterEntity(Level world, double x, double y, double z) {
        super((EntityType)ModEntities.GLOWING_WATER.get(), x, y, z, world);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    private boolean isUndead(LivingEntity e) {
        return e.m_6336_() == MobType.f_21641_;
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_) {
            this.spawnParticles();
            AABB bb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
            List eList = this.f_19853_.m_45976_(Mob.class, bb);
            eList.stream().filter(this::isUndead).forEach(e -> {
                float amount = 18.0f + (float)this.f_19796_.m_188503_(17);
                Entity thrower = this.m_37282_();
                if (thrower instanceof Player) {
                    Player player = (Player)thrower;
                    e.m_6469_(DamageSource.m_19344_((Player)player), amount);
                } else {
                    e.m_6469_(DamageSource.f_19319_, amount);
                }
            });
            this.f_19853_.m_46796_(2002, this.m_20183_(), 0);
            this.m_146870_();
        }
    }

    private void spawnParticles() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        ItemParticleOption itemParticleData = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.GLOWING_WATER.get()));
        for (int particleNum = 0; particleNum < 8; ++particleNum) {
            this.f_19853_.m_7106_((ParticleOptions)itemParticleData, x, y, z, this.f_19796_.m_188583_() * 0.15, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.15);
        }
        this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, this.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(Colors.get("3B64DC"), this.m_20185_(), this.m_20186_(), this.m_20189_()), new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 32.0, this.f_19853_.m_46472_()));
    }

    protected void m_8097_() {
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModItems.GLOWING_WATER.get());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

