/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import reliquary.init.ModEntities;
import reliquary.items.IceMagusRodItem;
import reliquary.reference.Settings;
import reliquary.util.RandHelper;

public class SpecialSnowballEntity
extends ThrowableItemProjectile {
    private boolean fromGlacialStaff;

    public SpecialSnowballEntity(EntityType<SpecialSnowballEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpecialSnowballEntity(Level world, LivingEntity entity, boolean b) {
        super((EntityType)ModEntities.SPECIAL_SNOWBALL.get(), entity, world);
        this.fromGlacialStaff = b;
    }

    private int getSnowballDamage() {
        return this.fromGlacialStaff ? (Integer)Settings.COMMON.items.glacialStaff.snowballDamage.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballDamage.get();
    }

    private int getSnowballDamageFireImmuneBonus() {
        return this.fromGlacialStaff ? (Integer)Settings.COMMON.items.glacialStaff.snowballDamageBonusFireImmune.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballDamageBonusFireImmune.get();
    }

    private int getSnowballDamageBlazeBonus() {
        return this.fromGlacialStaff ? (Integer)Settings.COMMON.items.glacialStaff.snowballDamageBonusBlaze.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballDamageBonusBlaze.get();
    }

    protected void m_6532_(HitResult result) {
        for (int var3 = 0; var3 < 8; ++var3) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123754_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            BlockPos posUp;
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                Entity entityHit = ((EntityHitResult)result).m_82443_();
                int damage = this.getSnowballDamage();
                if (entityHit.m_5825_()) {
                    damage += this.getSnowballDamageFireImmuneBonus();
                }
                if (entityHit instanceof Blaze) {
                    damage += this.getSnowballDamageBlazeBonus();
                }
                entityHit.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), (float)damage);
            } else if (result.m_6662_() == HitResult.Type.BLOCK && this.f_19853_.m_8055_(posUp = ((BlockHitResult)result).m_82425_().m_7494_()).m_60734_() instanceof BaseFireBlock) {
                this.f_19853_.m_5594_(null, posUp, SoundEvents.f_11909_, SoundSource.NEUTRAL, 0.5f, RandHelper.getRandomMinusOneToOne(this.f_19853_.f_46441_) * 0.8f);
                this.f_19853_.m_46597_(posUp, Blocks.f_50016_.m_49966_());
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 4 == this.f_19853_.f_46441_.m_188503_(5)) {
            this.f_19853_.m_7106_((ParticleOptions)IceMagusRodItem.ICE_PARTICLE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0, 5.0, 1.0);
        }
    }

    protected float m_7139_() {
        return 0.01f;
    }

    protected Item m_7881_() {
        return Items.f_42452_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            ItemStack stack = this.m_37454_();
            SimpleParticleType particleData = stack.m_41619_() ? ParticleTypes.f_123754_ : new ItemParticleOption(ParticleTypes.f_123752_, stack);
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)particleData, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 4.0;
        return distance < (d0 *= 64.0) * d0;
    }
}

