/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import reliquary.items.EnderStaffItem;
import reliquary.util.potions.XRPotionHelper;

public class TooltipBuilder {
    private final List<Component> tooltip;

    public static TooltipBuilder of(List<Component> tooltip) {
        return new TooltipBuilder(tooltip);
    }

    private TooltipBuilder(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public void potionEffects(List<MobEffectInstance> effects) {
        if (!effects.isEmpty()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (MobEffectInstance potioneffect : effects) {
                Object s1 = I18n.m_118938_((String)potioneffect.m_19576_(), (Object[])new Object[0]).trim();
                MobEffect potion = potioneffect.m_19544_();
                Map map = potion.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), potion.m_7048_(potioneffect.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        attributeModifiers.add(new Tuple((Object)((Attribute)entry.getKey()).m_22087_(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.m_19564_() > 0) {
                    s1 = (String)s1 + " " + I18n.m_118938_((String)("potion.potency." + potioneffect.m_19564_()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.m_19557_() > 20) {
                    s1 = (String)s1 + " (" + MobEffectUtil.m_19581_((MobEffectInstance)potioneffect, (float)1.0f) + ")";
                }
                if (potion.m_19486_()) {
                    this.tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + (String)s1)));
                    continue;
                }
                this.tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.RED + (String)s1)));
            }
            TooltipBuilder.addAttributeModifierTooltip(this.tooltip, attributeModifiers);
        }
    }

    private static void addAttributeModifierTooltip(List<Component> list, List<Tuple<String, AttributeModifier>> list1) {
        if (!list1.isEmpty()) {
            list.add((Component)Component.m_237113_((String)""));
            list.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"potion.whenDrank", (Object[])new Object[0]))));
            for (Tuple<String, AttributeModifier> tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.m_14419_();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((String)tuple.m_14418_()))}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((String)tuple.m_14418_()))}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void potionEffects(ItemStack stack) {
        this.potionEffects(XRPotionHelper.getPotionEffectsFromStack(stack));
    }

    public TooltipBuilder itemTooltip(Item item) {
        String langName = item.m_5524_() + ".tooltip";
        if (Language.m_128107_().m_6722_(langName)) {
            this.addTooltipLines(c -> c.m_130940_(ChatFormatting.GRAY), item.m_5524_() + ".tooltip", new Object[0]);
        }
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, int charge, int chargeLimit) {
        this.tooltip.add((Component)Component.m_237110_((String)(item.m_5524_() + langSuffix), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(charge)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(chargeLimit)).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder data(Item item, String langSuffix, Object ... args) {
        return this.data(item.m_5524_() + langSuffix, args);
    }

    public TooltipBuilder data(String langKey, Object ... args) {
        Object[] components;
        if (args.length > 0) {
            components = new Component[args.length];
            for (Object arg : args) {
                if (arg instanceof Component) {
                    Component argComponent = (Component)arg;
                    components[i] = argComponent;
                    continue;
                }
                components[i] = Component.m_237113_((String)String.valueOf(arg)).m_130940_(ChatFormatting.WHITE);
            }
        } else {
            components = new Component[]{};
        }
        this.tooltip.add((Component)Component.m_237110_((String)langKey, (Object[])components).m_130940_(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, String chargeName, int charge) {
        this.tooltip.add((Component)Component.m_237110_((String)(item.m_5524_() + langSuffix), (Object[])new Object[]{Component.m_237113_((String)chargeName).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(charge)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, int charge) {
        this.tooltip.add((Component)Component.m_237110_((String)(item.m_5524_() + langSuffix), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(charge)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder showMoreInfo() {
        if (!Screen.m_96638_()) {
            this.tooltip.add((Component)Component.m_237110_((String)"tooltip.reliquary.hold_for_more_info", (Object[])new Object[]{Component.m_237115_((String)"tooltip.reliquary.shift").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return this;
    }

    public TooltipBuilder absorb() {
        this.tooltip.add((Component)Component.m_237115_((String)"tooltip.reliquary.absorb").m_130940_(ChatFormatting.DARK_GRAY));
        return this;
    }

    public TooltipBuilder absorbActive(String itemName) {
        return this.absorbActive((Component)Component.m_237113_((String)itemName).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public TooltipBuilder absorbActive(Component thingName) {
        this.tooltip.add((Component)Component.m_237110_((String)"tooltip.reliquary.absorb_active", (Object[])new Object[]{thingName}).m_130940_(ChatFormatting.DARK_GRAY));
        return this;
    }

    public TooltipBuilder description(String langKey, Object ... args) {
        this.addTooltipLines(c -> c.m_130940_(ChatFormatting.DARK_GRAY), langKey, args);
        return this;
    }

    public TooltipBuilder description(Item item, String langSuffix, Object ... args) {
        return this.description(item.m_5524_() + langSuffix, args);
    }

    public TooltipBuilder warning(EnderStaffItem enderStaffItem, String langSuffix) {
        this.tooltip.add((Component)Component.m_237115_((String)(enderStaffItem.m_5524_() + langSuffix)).m_130940_(ChatFormatting.RED));
        return this;
    }

    private void addTooltipLines(UnaryOperator<MutableComponent> applyStyle, String langKey, Object ... args) {
        String[] lines;
        String text = Language.m_128107_().m_6834_(langKey);
        for (String line : lines = text.split("\n")) {
            this.tooltip.add((Component)applyStyle.apply(Component.m_237110_((String)line, (Object[])args)));
        }
    }
}

