/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class EndGatewayProcessor
extends StructureProcessor {
    public static final Codec<EndGatewayProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.optionalFieldOf("exit_position").forGetter(config -> config.exitPos)).apply((Applicative)instance, instance.stable(EndGatewayProcessor::new)));
    private final Optional<BlockPos> exitPos;

    private EndGatewayProcessor(Optional<BlockPos> exitPos) {
        this.exitPos = exitPos;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.f_74676_.m_60713_(Blocks.f_50446_)) {
            if (this.exitPos.isPresent()) {
                CompoundTag compoundTag = structureBlockInfoWorld.f_74677_ == null || structureBlockInfoWorld.f_74677_.m_128456_() ? new CompoundTag() : structureBlockInfoWorld.f_74677_.m_6426_();
                compoundTag.m_128365_("ExitPortal", (Tag)NbtUtils.m_129224_((BlockPos)this.exitPos.get()));
                return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_, structureBlockInfoWorld.f_74676_, compoundTag);
            }
            BlockPos currentPos = structureBlockInfoWorld.f_74675_;
            ChunkAccess currentChunk = levelReader.m_46865_(currentPos);
            int terrainY = currentChunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, 0, 0);
            if (terrainY <= currentChunk.m_141937_() || terrainY >= currentChunk.m_151558_()) {
                terrainY = currentChunk.m_141937_() + 1;
                currentChunk.m_6978_(new BlockPos(0, currentChunk.m_141937_(), 0), Blocks.f_50080_.m_49966_(), false);
            }
            CompoundTag compoundTag = structureBlockInfoWorld.f_74677_ == null ? new CompoundTag() : structureBlockInfoWorld.f_74677_;
            compoundTag.m_128365_("ExitPortal", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(0, terrainY, 0)));
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_, structureBlockInfoWorld.f_74676_, compoundTag);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)RSProcessors.END_GATEWAY_PROCESSOR.get();
    }
}

