/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePlacementType;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class AdvancedRandomSpread
extends RandomSpreadStructurePlacement {
    public static final Codec<AdvancedRandomSpread> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).m_227075_()), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).m_227076_()), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AdvancedRandomSpread::superExclusionZone), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spacing").forGetter(AdvancedRandomSpread::m_205003_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("separation").forGetter(AdvancedRandomSpread::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(AdvancedRandomSpread::m_205005_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("min_distance_from_world_origin").forGetter(AdvancedRandomSpread::minDistanceFromWorldOrigin)).apply((Applicative)instance, instance.stable(AdvancedRandomSpread::new)));
    private final int spacing;
    private final int separation;
    private final RandomSpreadType spreadType;
    private final Optional<Integer> minDistanceFromWorldOrigin;
    private final Optional<SuperExclusionZone> superExclusionZone;

    public AdvancedRandomSpread(Vec3i locationOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Optional<SuperExclusionZone> superExclusionZone, int spacing, int separation, RandomSpreadType spreadType, Optional<Integer> minDistanceFromWorldOrigin) {
        super(locationOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
        this.minDistanceFromWorldOrigin = minDistanceFromWorldOrigin;
        this.superExclusionZone = superExclusionZone;
        if (spacing <= separation) {
            throw new RuntimeException("    Repurposed Structures: Spacing cannot be less or equal to separation.\n    Please correct this error as there's no way to spawn this structure properly\n        Spacing: %s\n        Separation: %s.\n".formatted(spacing, separation));
        }
    }

    public int m_205003_() {
        return this.spacing;
    }

    public int m_205004_() {
        return this.separation;
    }

    public RandomSpreadType m_205005_() {
        return this.spreadType;
    }

    public Optional<Integer> minDistanceFromWorldOrigin() {
        return this.minDistanceFromWorldOrigin;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public boolean m_227054_(ChunkGenerator chunkGenerator, RandomState randomState, long l, int i, int j) {
        if (!super.m_227054_(chunkGenerator, randomState, l, i, j)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(chunkGenerator, randomState, l, i, j);
    }

    public ChunkPos m_227008_(long seed, int x, int z) {
        int regionX = Math.floorDiv(x, this.spacing);
        int regionZ = Math.floorDiv(z, this.spacing);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190058_(seed, regionX, regionZ, this.m_227075_());
        int diff = this.spacing - this.separation;
        int offsetX = this.spreadType.m_227018_((RandomSource)worldgenrandom, diff);
        int offsetZ = this.spreadType.m_227018_((RandomSource)worldgenrandom, diff);
        return new ChunkPos(regionX * this.spacing + offsetX, regionZ * this.spacing + offsetZ);
    }

    protected boolean m_214090_(ChunkGenerator chunkGenerator, RandomState randomState, long seed, int x, int z) {
        int zBlockPos;
        int xBlockPos;
        if (this.minDistanceFromWorldOrigin.isPresent() && (xBlockPos = x * 16) * xBlockPos + (zBlockPos = z * 16) * zBlockPos < this.minDistanceFromWorldOrigin.get() * this.minDistanceFromWorldOrigin.get()) {
            return false;
        }
        ChunkPos chunkpos = this.m_227008_(seed, x, z);
        return chunkpos.f_45578_ == x && chunkpos.f_45579_ == z;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)RSStructurePlacementType.ADVANCED_RANDOM_SPREAD.get();
    }

    public record SuperExclusionZone(HolderSet<StructureSet> otherSet, int chunkCount) {
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.m_206279_((ResourceKey)Registry.f_211073_, (Codec)StructureSet.f_210001_).fieldOf("other_set").forGetter(SuperExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(SuperExclusionZone::chunkCount)).apply((Applicative)builder, SuperExclusionZone::new));

        boolean isPlacementForbidden(ChunkGenerator chunkGenerator, RandomState randomState, long l, int i, int j) {
            for (Holder holder : this.otherSet) {
                if (!chunkGenerator.m_223141_(holder, randomState, l, i, j, this.chunkCount)) continue;
                return true;
            }
            return false;
        }
    }
}

