/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.forge;

import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.forge.ForgeConfigUtils;
import java.lang.reflect.Field;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeResourcefulConfigEntry
implements ResourcefulConfigEntry {
    private final EntryType type;
    private final Field field;
    private final Object defaultValue;
    private final ForgeConfigSpec.ConfigValue<?> configValue;

    private ForgeResourcefulConfigEntry(EntryType type, Field field, Object defaultValue, ForgeConfigSpec.ConfigValue<?> configValue) {
        this.type = type;
        this.field = field;
        this.defaultValue = defaultValue;
        this.configValue = configValue;
    }

    public static ForgeResourcefulConfigEntry create(ConfigEntry entry, Field field, ForgeConfigSpec.Builder builder) {
        Object value = ParsingUtils.getField(field);
        ForgeConfigSpec.ConfigValue<?> configValue = ForgeConfigUtils.addEntry(builder, entry.id(), field, entry.type(), value);
        return new ForgeResourcefulConfigEntry(entry.type(), field, value, configValue);
    }

    @Override
    public EntryType type() {
        return this.type;
    }

    @Override
    public Field field() {
        return this.field;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    public void saveEntry() {
        ForgeConfigUtils.setEntry(this.configValue, ParsingUtils.getField(this.field));
    }
}

