/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.state;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public final class StateVariant {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Codec<List<BlockState>> stateCodec(Block block) {
        StateDefinition stateDefinition = block.m_49965_();
        return Codec.STRING.flatXmap(string -> StateVariant.getStates((StateDefinition<Block, BlockState>)stateDefinition, string), state -> DataResult.error((String)"State variants can not be encoded back to a string."));
    }

    private static DataResult<List<BlockState>> getStates(StateDefinition<Block, BlockState> definition, String input) {
        List<BlockState> states = definition.m_61056_().stream().filter(StateVariant.predicate(definition, input)).toList();
        return states.isEmpty() ? DataResult.error((String)("No states found for " + input)) : DataResult.success(states);
    }

    private static Predicate<BlockState> predicate(StateDefinition<Block, BlockState> state, String stateString) {
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)stateString)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)iterator.next();
            Property property = state.m_61081_(key);
            if (property != null && iterator.hasNext()) {
                String value = (String)iterator.next();
                Comparable comparable = property.m_6215_(value).orElse(null);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + value + "' for blockstate property: '" + key + "' " + property.m_6908_());
                }
                map.put(property, comparable);
                continue;
            }
            if (key.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + key + "'");
        }
        return stateIn -> {
            if (stateIn != null && stateIn.m_60713_((Block)state.m_61091_())) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(stateIn.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }
}

