/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import shetiphian.core.common.network.PacketBase;

public abstract class PacketPipeline {
    private final SimpleChannel wrapper;

    public PacketPipeline(String modId, String version) {
        this.wrapper = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "main_channel")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
        this.registerPackets(this.wrapper);
    }

    public abstract void registerPackets(SimpleChannel var1);

    public static void onMessage(PacketBase packet, Supplier<NetworkEvent.Context> ctx) {
        switch (ctx.get().getDirection()) {
            case PLAY_TO_CLIENT: 
            case LOGIN_TO_CLIENT: {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketPipeline.lambda$onMessage$1(packet, (Supplier)ctx));
                break;
            }
            case PLAY_TO_SERVER: 
            case LOGIN_TO_SERVER: {
                ctx.get().enqueueWork(() -> packet.handleServerSide((Player)((NetworkEvent.Context)ctx.get()).getSender()));
            }
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onMessageClient(PacketBase packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> packet.handleClientSide((Player)Minecraft.m_91087_().f_91074_));
    }

    public void sendPacketToServer(PacketBase packet) {
        this.wrapper.sendToServer((Object)packet);
    }

    public void sendPacketToPlayer(PacketBase packet, ServerPlayer player) {
        this.wrapper.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendPacketToPlayer(PacketBase packet, UUID uuid) {
        for (ServerPlayer player : this.getPlayers()) {
            if (!player.m_20148_().equals(uuid)) continue;
            this.sendPacketToPlayer(packet, player);
            break;
        }
    }

    public void sendPacketToList(PacketBase packet, List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToIdList(PacketBase packet, List<UUID> players) {
        for (ServerPlayer player : this.getPlayers()) {
            if (!players.contains(player.m_20148_())) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToAll(PacketBase packet) {
        this.sendPacketToList(packet, this.getPlayers());
    }

    public void sendPacketToAllAround(PacketBase packet, Entity entity, double range) {
        this.sendPacketToAllAround(packet, entity.m_9236_().m_6042_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), range);
    }

    public void sendPacketToAllAround(PacketBase packet, DimensionType dimension, BlockPos pos, double range) {
        this.sendPacketToAllAround(packet, dimension, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), range);
    }

    public void sendPacketToAllAround(PacketBase packet, DimensionType dimension, double x, double y, double z, double range) {
        for (ServerPlayer player : this.getPlayers()) {
            double posZ;
            double posY;
            double posX;
            if (player.m_9236_().m_6042_() != dimension || !((posX = x - player.m_20185_()) * posX + (posY = y - player.m_20186_()) * posY + (posZ = z - player.m_20189_()) * posZ < range * range)) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToDimension(PacketBase packet, DimensionType dimension) {
        for (ServerPlayer player : this.getPlayers()) {
            if (player.m_9236_().m_6042_() != dimension) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    private List<ServerPlayer> getPlayers() {
        PlayerList playerList = null;
        try {
            playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerList != null ? playerList.m_11314_() : new ArrayList();
    }

    private static /* synthetic */ void lambda$onMessage$1(PacketBase packet, Supplier ctx) {
        PacketPipeline.onMessageClient(packet, ctx);
    }
}

