/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.data.material.MaterialBuilder;
import net.silentchaos512.gear.data.DataGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class MaterialsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public MaterialsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    protected abstract Collection<MaterialBuilder> getMaterials();

    protected ResourceLocation modId(String path) {
        return new ResourceLocation(this.modId, path);
    }

    protected static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    @NotNull
    public String m_6055_() {
        return "Silent Gear Materials: " + this.modId;
    }

    public void m_213708_(@NotNull CachedOutput cache) {
        Path outputFolder = this.generator.m_123916_();
        HashSet entries = Sets.newHashSet();
        this.getMaterials().forEach(builder -> {
            if (entries.contains(builder.getId())) {
                throw new IllegalStateException("Duplicate material: " + builder.getId());
            }
            entries.add(builder.getId());
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_materials/%s.json", builder.getId().m_135827_(), builder.getId().m_135815_()));
            MaterialsProviderBase.trySaveStable(cache, builder, path);
        });
    }

    private static void trySaveStable(CachedOutput cache, MaterialBuilder builder, Path path) {
        try {
            DataGenerators.saveStable(cache, (JsonElement)builder.serialize(), path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

