/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.EvenSplitItemStat;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.utils.Color;

public final class ItemStats {
    private static final Map<ResourceLocation, ItemStat> REGISTRY = new LinkedHashMap<ResourceLocation, ItemStat>();
    static final List<ItemStat> STATS_IN_ORDER = new ArrayList<ItemStat>();
    public static final ItemStat DURABILITY = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("durability"), 0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies()));
    public static final ItemStat ARMOR_DURABILITY = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("armor_durability"), 0.0f, 0.0f, 1.3421773E8f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies()));
    public static final ItemStat REPAIR_EFFICIENCY = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("repair_efficiency"), 1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false)));
    public static final ItemStat REPAIR_VALUE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("repair_value"), 1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false)));
    public static final ItemStat ENCHANTMENT_VALUE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("enchantment_value"), 0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies()));
    public static final ItemStat CHARGING_VALUE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("charging_value"), 1.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().affectedByGrades(false)));
    public static final ItemStat RARITY = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("rarity"), 0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(false)));
    public static final ItemStat HARVEST_LEVEL = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("harvest_level"), 0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().defaultOp(StatInstance.Operation.MAX).displayAsInt().affectedByGrades(false)));
    public static final ItemStat HARVEST_SPEED = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("harvest_speed"), 0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(true).synergyApplies()));
    public static final ItemStat REACH_DISTANCE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("reach_distance"), 0.0f, -100.0f, 100.0f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(false)));
    public static final ItemStat MELEE_DAMAGE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("melee_damage"), 0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies()));
    public static final ItemStat MAGIC_DAMAGE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("magic_damage"), 0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies().hidden()));
    public static final ItemStat ATTACK_SPEED = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("attack_speed"), 0.0f, -3.9f, 4.0f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(false)));
    public static final ItemStat ATTACK_REACH = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("attack_reach"), 3.0f, 0.0f, 100.0f, Color.SANDYBROWN, new ItemStat.Properties().baseValue(3.0f).affectedByGrades(false)));
    public static final ItemStat RANGED_DAMAGE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("ranged_damage"), 0.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies()));
    public static final ItemStat RANGED_SPEED = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("ranged_speed"), 0.0f, -10.0f, 10.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false)));
    public static final ItemStat PROJECTILE_SPEED = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("projectile_speed"), 1.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false).synergyApplies()));
    public static final ItemStat PROJECTILE_ACCURACY = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("projectile_accuracy"), 1.0f, 0.0f, 10000.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false)));
    public static final ItemStat ARMOR = ItemStats.register(new SplitItemStat((ResourceLocation)SilentGear.getId("armor"), 0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, (Map<GearType, Float>)ImmutableMap.of((Object)GearType.HELMET, (Object)Float.valueOf(3.0f), (Object)GearType.CHESTPLATE, (Object)Float.valueOf(8.0f), (Object)GearType.LEGGINGS, (Object)Float.valueOf(6.0f), (Object)GearType.BOOTS, (Object)Float.valueOf(3.0f)), new ItemStat.Properties().affectedByGrades(true).synergyApplies()));
    public static final ItemStat ARMOR_TOUGHNESS = ItemStats.register(new EvenSplitItemStat((ResourceLocation)SilentGear.getId("armor_toughness"), 0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies()));
    public static final ItemStat KNOCKBACK_RESISTANCE = ItemStats.register(new ItemStat((ResourceLocation)SilentGear.getId("knockback_resistance"), 0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, new ItemStat.Properties().affectedByGrades(true).synergyApplies()));
    public static final ItemStat MAGIC_ARMOR = ItemStats.register(new EvenSplitItemStat((ResourceLocation)SilentGear.getId("magic_armor"), 0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies()));

    private ItemStats() {
    }

    public static ItemStat register(ItemStat stat) {
        REGISTRY.put(stat.getStatId(), stat);
        return stat;
    }

    public static Collection<ItemStat> allStatsOrdered() {
        return Collections.unmodifiableList(STATS_IN_ORDER);
    }

    public static Collection<ItemStat> allStatsOrderedExcluding(Collection<ItemStat> exclude) {
        ArrayList<ItemStat> ret = new ArrayList<ItemStat>(STATS_IN_ORDER);
        ret.removeIf(exclude::contains);
        return ret;
    }

    @Nullable
    public static ItemStat byName(String name) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(name);
        return id != null ? REGISTRY.get(id) : null;
    }

    @Nullable
    public static ItemStat byName(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    @Nullable
    public static ItemStat get(IItemStat stat) {
        return REGISTRY.get(stat.getStatId());
    }
}

