/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.init.SgBlocks;
import net.silentchaos512.gear.init.SgTags;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.TagUtils;

public class MaterialGraderRecipeCategory
implements IRecipeCategory<GraderRecipe> {
    private static final int GUI_START_X = 24;
    private static final int GUI_START_Y = 33;
    private static final int GUI_WIDTH = 19;
    private static final int GUI_HEIGHT = 39;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public MaterialGraderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GraderScreen.TEXTURE, 24, 33, 19, 39);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(SgBlocks.MATERIAL_GRADER));
        this.localizedName = TextUtil.translate("jei", "category.grading");
    }

    public RecipeType<GraderRecipe> getRecipeType() {
        return SGearJeiPlugin.GRADING_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GraderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, MaterialGraderRecipeCategory.getMaterials());
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 22).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, MaterialGraderRecipeCategory.getCatalysts());
    }

    @Nonnull
    public static List<ItemStack> getMaterials() {
        return MaterialManager.getValues().stream().map(IGearComponent::getIngredient).flatMap(ing -> Arrays.stream(ing.m_43908_())).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return TagUtils.getItemsInTag(SgTags.Items.GRADER_CATALYSTS).map(ItemStack::new).collect(Collectors.toList());
    }

    public static class GraderRecipe {
    }
}

