/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.utils.MathUtils;

public final class DurabilityTrait
extends SimpleTrait {
    public static final ResourceLocation TRIGGER_BRITTLE = SilentGear.getId("brittle_proc");
    public static final ITraitSerializer<DurabilityTrait> SERIALIZER = new SimpleTrait.Serializer<DurabilityTrait>(ApiConst.DURABILITY_TRAIT_ID, DurabilityTrait::new, (trait, json) -> {
        trait.activationChance = GsonHelper.m_13820_((JsonObject)json, (String)"activation_chance", (float)1.0f);
        trait.effectScale = GsonHelper.m_13824_((JsonObject)json, (String)"effect_scale", (int)0);
    }, (trait, buffer) -> {
        trait.activationChance = buffer.readFloat();
        trait.effectScale = buffer.readFloat();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.activationChance);
        buffer.writeFloat(trait.effectScale);
    });
    private float activationChance;
    private float effectScale;

    private DurabilityTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        Player player = context.getPlayer();
        if (damageTaken != 0 && this.shouldActivate(context.getTraitLevel())) {
            if (this.effectScale > 0.0f && player instanceof ServerPlayer) {
                LibTriggers.GENERIC_INT.trigger((ServerPlayer)player, TRIGGER_BRITTLE, 1);
            }
            return Math.round((float)damageTaken + this.effectScale);
        }
        return super.onDurabilityDamage(context, damageTaken);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        int chancePercent = (int)(100.0f * this.activationChance);
        String line = String.format("  - %.1f damage with a %d%% chance per level", Float.valueOf(this.effectScale), chancePercent);
        ret.add(line);
        return ret;
    }

    private boolean shouldActivate(int level) {
        return MathUtils.tryPercentage((double)(this.activationChance * (float)level));
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

