/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;

public class GearArrowItem
extends ArrowItem
implements ICoreItem {
    private static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.RANGED_DAMAGE, (Object)ItemStats.PROJECTILE_SPEED, (Object)ItemStats.PROJECTILE_ACCURACY);
    private static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.ARMOR_DURABILITY, (Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object)ItemStats.ATTACK_REACH, (Object)ItemStats.RANGED_SPEED, (Object[])new ItemStat[]{ItemStats.ARMOR, ItemStats.ARMOR_TOUGHNESS, ItemStats.MAGIC_ARMOR, ItemStats.KNOCKBACK_RESISTANCE});
    private static final Collection<PartType> REQUIRED_PARTS = ImmutableList.of((Object)PartType.MAIN, (Object)PartType.ROD, (Object)PartType.FLETCHING);

    public GearArrowItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public GearType getGearType() {
        return GearType.ARROW;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        int durability = GearData.getStatInt(stack, this.getDurabilityStat());
        if (durability == 0) {
            return 1.0f;
        }
        return (float)this.getMaxDamage(stack) / (float)durability;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS;
    }

    @Override
    public Collection<PartType> getRenderParts() {
        return ImmutableList.of((Object)PartType.ROD, (Object)PartType.FLETCHING, (Object)PartType.MAIN);
    }

    @Override
    public ItemStack construct(Collection<? extends IPartData> parts) {
        ItemStack result = ICoreItem.super.construct(parts);
        result.m_41721_(result.m_41776_() - 64);
        return result;
    }

    @Override
    public boolean hasTexturesFor(PartType partType) {
        return REQUIRED_PARTS.contains(partType) || partType.isUpgrade();
    }

    public AbstractArrow m_6394_(Level worldIn, ItemStack stack, LivingEntity shooter) {
        GearArrowEntity arrow = new GearArrowEntity(worldIn, shooter);
        arrow.setArrowStack(stack);
        arrow.m_36781_(GearData.getStat(stack, ItemStats.RANGED_DAMAGE));
        if (shooter instanceof Player && !((Player)shooter).m_150110_().f_35937_) {
            stack.m_41721_(stack.m_41773_() + 1);
        }
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return !GearHelper.isBroken(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack usedStack = playerIn.m_21120_(handIn);
        boolean used = false;
        if (usedStack.m_41773_() > 0) {
            for (ItemStack stack : playerIn.m_150109_().f_35974_) {
                if (stack.m_41720_() != this || stack.m_41773_() <= 0 || !GearHelper.isEquivalent(usedStack, stack)) continue;
                int count = stack.m_41776_() - stack.m_41773_();
                int merged = Math.min(usedStack.m_41773_(), count);
                usedStack.m_41721_(usedStack.m_41773_() - merged);
                stack.m_41721_(stack.m_41773_() + merged);
                used |= usedStack.m_41773_() != stack.m_41773_();
                if (stack.m_41773_() >= stack.m_41776_()) {
                    playerIn.m_150109_().m_36057_(stack);
                }
                if (usedStack.m_41773_() > 0) continue;
                break;
            }
        }
        return used ? InteractionResultHolder.m_19090_((Object)usedStack) : InteractionResultHolder.m_19098_((Object)usedStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return GearHelper.onItemUse(context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!(KeyTracker.isDisplayStatsDown() || KeyTracker.isDisplayTraitsDown() || KeyTracker.isDisplayConstructionDown())) {
            tooltip.add((Component)Component.m_237113_((String)"Do not use with vanilla crossbows, see issue #270").m_130940_(ChatFormatting.RED));
        }
        tooltip.add((Component)TextUtil.misc("ammo", stack.m_41776_() - stack.m_41773_()));
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return 256;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColor(stack, PartType.ROD);
            case 1 -> ColorUtils.getBlendedColor(stack, PartType.MAIN);
            case 3 -> ColorUtils.getBlendedColor(stack, PartType.FLETCHING);
            default -> 0xFFFFFF;
        };
    }
}

