/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.EnchantmentTrait;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.network.RecalculateStatsPacket;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.util.NameUtils;

public final class GearData {
    private static final String NBT_ROOT = "SGear_Data";
    private static final String NBT_ROOT_CONSTRUCTION = "Construction";
    private static final String NBT_ROOT_PROPERTIES = "Properties";
    private static final String NBT_ROOT_RENDERING = "Rendering";
    private static final String NBT_ROOT_STATISTICS = "Statistics";
    private static final String NBT_CONSTRUCTION_PARTS = "Parts";
    private static final String NBT_LOCK_STATS = "LockStats";
    private static final String NBT_IS_EXAMPLE = "IsExample";
    private static final String NBT_MODEL_KEY = "ModelKey";
    private static final String NBT_MODEL = "Model";
    private static final String NBT_SYNERGY = "synergy";
    private static final String NBT_TIER = "Tier";
    private static final String NBT_UUID = "SGear_UUID";
    private static final String NBT_BROKEN_COUNT = "BrokenCount";
    private static final String NBT_REPAIR_COUNT = "RepairCount";
    private static final String NBT_STATS = "Stats";

    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    public static void recalculateStats(ItemStack stack) {
        GearData.recalculateStats(stack, null);
    }

    public static void recalculateStats(ItemStack gear, @Nullable Player player) {
        try {
            GearData.tryRecalculateStats(gear, player);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.m_127521_((Throwable)ex, (String)"Failed to recalculate gear properties");
            CrashReportCategory itemCategory = report.m_127514_("Gear Item");
            itemCategory.m_128159_("Name", (Object)(gear.m_41786_().getString() + " (" + NameUtils.fromItem((ItemStack)gear) + ")"));
            itemCategory.m_128159_("Data", (Object)gear.m_41784_().toString());
            throw new ReportedException(report);
        }
    }

    private static void tryRecalculateStats(ItemStack gear, @Nullable Player player) {
        boolean partsListValid;
        if (GearData.checkNonGearItem(gear, "recalculateStats")) {
            return;
        }
        GearData.getUUID(gear);
        TraitHelper.activateTraits(gear, 0.0f, (trait, level, value) -> {
            trait.onRecalculatePre(new TraitActionContext(player, level, gear));
            return 0.0f;
        });
        ICoreItem item = (ICoreItem)gear.m_41720_();
        PartDataList parts = GearData.getConstructionParts(gear);
        CompoundTag propertiesCompound = GearData.getData(gear, NBT_ROOT_PROPERTIES);
        if (!propertiesCompound.m_128441_(NBT_LOCK_STATS)) {
            propertiesCompound.m_128379_(NBT_LOCK_STATS, false);
        }
        String playerName = player != null ? player.m_6302_() : "somebody";
        String playersItemText = String.format("%s's %s", playerName, gear.m_41786_().getString());
        boolean statsUnlocked = !propertiesCompound.m_128471_(NBT_LOCK_STATS);
        boolean bl = partsListValid = !parts.isEmpty() && !parts.getMains().isEmpty();
        if (statsUnlocked && partsListValid) {
            if (player != null) {
                SilentGear.LOGGER.debug("Recalculating for {}", (Object)playersItemText);
            }
            GearData.clearCachedData(gear);
            propertiesCompound.m_128359_("ModVersion", SilentGear.getVersion());
            Map<ITrait, Integer> traits = TraitHelper.getTraits(gear, item.getGearType(), parts);
            StatModifierMap stats = GearData.getStatModifiers(gear, item, parts);
            Map<ItemStat, Float> oldStatValues = GearData.getCurrentStatsForDebugging(gear);
            ListTag traitList = new ListTag();
            traits.forEach((trait, level) -> traitList.add((Object)trait.write((int)level)));
            propertiesCompound.m_128365_("Traits", (Tag)traitList);
            propertiesCompound.m_128473_(NBT_SYNERGY);
            int maxDamage = gear.m_41776_() > 0 ? gear.m_41776_() : 1;
            float damageRatio = Mth.m_14036_((float)((float)gear.m_41773_() / (float)maxDamage), (float)0.0f, (float)1.0f);
            CompoundTag statsCompound = new CompoundTag();
            for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item.getExcludedStats(gear))) {
                StatGearKey key = StatGearKey.of(stat, item.getGearType());
                Collection<StatInstance> modifiers = stats.get(key);
                GearType statGearType = stats.getMostSpecificKey(key).getGearType();
                float initialValue = stat.compute(stat.getBaseValue(), true, item.getGearType(), statGearType, modifiers);
                float withTraits = TraitHelper.activateTraits(gear, initialValue, (trait, level, val) -> {
                    TraitActionContext context = new TraitActionContext(player, level, gear);
                    return trait.onGetStat(context, stat, val, damageRatio);
                });
                float value2 = Config.Common.getStatWithMultiplier(stat, withTraits);
                if (Mth.m_14033_((float)value2, (float)0.0f) && !stats.containsKey(key)) continue;
                ResourceLocation statId = Objects.requireNonNull(stat.getStatId());
                propertiesCompound.m_128473_(statId.m_135815_());
                statsCompound.m_128350_(statId.toString(), stat.clampValue(value2));
            }
            for (ItemStat stat : item.getRelevantStats(gear)) {
                String statKey = stat.getStatId().toString();
                if (statsCompound.m_128441_(statKey)) continue;
                statsCompound.m_128350_(statKey, stat.getDefaultValue());
            }
            propertiesCompound.m_128365_(NBT_STATS, (Tag)statsCompound);
            if (player != null) {
                GearData.printStatsForDebugging(gear, stats, oldStatValues);
            }
            if (gear.m_41784_().m_128441_("Enchantments") && ((Boolean)Config.Common.forceRemoveEnchantments.get()).booleanValue()) {
                SilentGear.LOGGER.debug("Forcibly removing all enchantments from {} as per config settings", (Object)playersItemText);
                gear.m_41749_("Enchantments");
            }
            EnchantmentTrait.removeTraitEnchantments(gear);
            TraitHelper.activateTraits(gear, 0.0f, (trait, level, value) -> {
                trait.onRecalculatePost(new TraitActionContext(player, level, gear));
                return 0.0f;
            });
        } else {
            SilentGear.LOGGER.debug("Not recalculating stats for {}", (Object)playersItemText);
        }
        GearData.updateRenderingInfo(gear, parts);
    }

    @Nullable
    private static Map<ItemStat, Float> getCurrentStatsForDebugging(ItemStack stack) {
        if (((Boolean)Config.Common.statsDebugLogging.get()).booleanValue()) {
            HashMap<ItemStat, Float> map = new HashMap<ItemStat, Float>();
            ItemStats.allStatsOrdered().forEach(stat -> map.put((ItemStat)stat, Float.valueOf(GearData.getStat(stack, stat, false))));
            return map;
        }
        return null;
    }

    private static void printStatsForDebugging(ItemStack stack, StatModifierMap stats, @Nullable Map<ItemStat, Float> oldStats) {
        if (oldStats != null && SilentGear.LOGGER.isDebugEnabled()) {
            GearType gearType = GearHelper.getType(stack);
            Map<ItemStat, Float> newStats = GearData.getCurrentStatsForDebugging(stack);
            assert (newStats != null);
            for (ItemStat stat : stats.getStats()) {
                float oldValue = oldStats.get(stat).floatValue();
                float newValue = newStats.get(stat).floatValue();
                float change = newValue - oldValue;
                SilentGear.LOGGER.debug(" - {}: {} -> {} ({}) - mods: [{}]", (Object)stat.getDisplayName().getString(), (Object)Float.valueOf(oldValue), (Object)Float.valueOf(newValue), change < 0.0f ? Float.valueOf(change) : "+" + change, (Object)StatModifierMap.formatText(stats.get(stat, gearType), stat, 5).getString());
            }
        }
    }

    private static void clearCachedData(ItemStack stack) {
        CompoundTag construction = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        construction.m_128473_(NBT_TIER);
    }

    public static String getModelKey(ItemStack stack, int animationFrame) {
        String fromNbt = GearData.getData(stack, NBT_ROOT_RENDERING).m_128461_(NBT_MODEL_KEY);
        String key = fromNbt.isEmpty() ? GearData.getUUID(stack).toString() : fromNbt;
        return animationFrame > 0 ? key + "_" + animationFrame : key;
    }

    private static String calculateModelKey(ItemStack stack, Collection<? extends IPartData> parts) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + ":");
        for (IPartData iPartData : parts) {
            s.append(iPartData.getModelKey()).append(',');
        }
        return s.toString();
    }

    private static void updateRenderingInfo(ItemStack stack, Collection<? extends IPartData> parts) {
        CompoundTag nbt = GearData.getData(stack, NBT_ROOT_RENDERING);
        nbt.m_128473_("ArmorColor");
        nbt.m_128473_("BlendedHeadColor");
        nbt.m_128359_(NBT_MODEL_KEY, GearData.calculateModelKey(stack, parts));
        nbt.m_128405_(NBT_MODEL, GearData.calculateModelIndex(stack));
        stack.m_41698_(NBT_ROOT).m_128473_("ModelKeys");
    }

    public static StatModifierMap getStatModifiers(ItemStack stack, ICoreItem item, PartDataList parts) {
        GearType gearType = item.getGearType();
        StatModifierMap stats = new StatModifierMap();
        for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item.getExcludedStats(stack))) {
            StatGearKey itemKey = StatGearKey.of(stat, gearType);
            for (PartData part : parts) {
                for (StatInstance mod : part.getStatModifiers(itemKey, stack)) {
                    StatInstance modCopy = StatInstance.of(mod.getValue(), mod.getOp(), itemKey);
                    stats.put(modCopy.getKey(), modCopy);
                }
            }
        }
        return stats;
    }

    public static float getStat(ItemStack stack, IItemStat stat) {
        return GearData.getStat(stack, stat, true);
    }

    public static float getStat(ItemStack stack, IItemStat stat, boolean calculateIfMissing) {
        Level level;
        String key;
        CompoundTag tags = GearData.getData(stack, NBT_ROOT_PROPERTIES).m_128469_(NBT_STATS);
        if (tags.m_128441_(key = stat.getStatId().toString())) {
            return tags.m_128457_(key);
        }
        if (calculateIfMissing && (level = SilentGear.PROXY.getClientLevel()) != null && SilentGear.PROXY.checkClientConnection() && GearHelper.isValidGear(stack) && ((ICoreItem)stack.m_41720_()).getRelevantStats(stack).contains(stat)) {
            SilentGear.LOGGER.debug("Sending recalculate stats packet for item with missing {} stat: {}", (Object)stat.getStatId(), (Object)stack.m_41786_().getString());
            Network.channel.sendToServer((Object)new RecalculateStatsPacket(level, stack, stat));
            GearData.putStatInNbtIfMissing(stack, stat);
        }
        return stat.getDefaultValue();
    }

    public static int getStatInt(ItemStack stack, IItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public static void putStatInNbtIfMissing(ItemStack stack, IItemStat stat) {
        String key;
        CompoundTag tags = GearData.getData(stack, NBT_ROOT_PROPERTIES).m_128469_(NBT_STATS);
        if (!tags.m_128441_(key = stat.getStatId().toString())) {
            tags.m_128350_(key, stat.getDefaultValue());
        }
    }

    public static boolean hasLockedStats(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES).m_128471_(NBT_LOCK_STATS);
    }

    public static void setLockedStats(ItemStack stack, boolean lock) {
        GearData.getData(stack, NBT_ROOT_PROPERTIES).m_128379_(NBT_LOCK_STATS, lock);
    }

    public static PartDataList getConstructionParts(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            return PartDataList.empty();
        }
        CompoundTag tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListTag tagList = tags.m_128437_(NBT_CONSTRUCTION_PARTS, 10);
        PartDataList list = PartDataList.of(new PartData[0]);
        for (Tag nbt : tagList) {
            CompoundTag partCompound;
            PartData part;
            if (!(nbt instanceof CompoundTag) || (part = PartData.read(partCompound = (CompoundTag)nbt)) == null) continue;
            list.add(part);
        }
        return list;
    }

    @Deprecated
    public static float getSynergyDisplayValue(ItemStack gear) {
        return 0.0f;
    }

    public static int getTier(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return -1;
        }
        CompoundTag data = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        if (!data.m_128441_(NBT_TIER)) {
            List<PartData> parts = GearData.getConstructionParts(gear).getMains();
            int max = 0;
            for (PartData part : parts) {
                if (part.getTier() <= max) continue;
                max = part.getTier();
            }
            data.m_128405_(NBT_TIER, max);
        }
        return data.m_128451_(NBT_TIER);
    }

    public static int getModelIndex(ItemStack gear) {
        CompoundTag nbt = GearData.getData(gear, NBT_ROOT_RENDERING);
        if (nbt.m_128441_(NBT_MODEL)) {
            return nbt.m_128451_(NBT_MODEL);
        }
        return 0;
    }

    private static int calculateModelIndex(ItemStack gear) {
        int ret;
        PartData coatingOrMainPart = GearData.getCoatingOrMainPart(gear);
        if (coatingOrMainPart == null || coatingOrMainPart.getMaterials().isEmpty()) {
            return -1;
        }
        IMaterialInstance mainMaterial = coatingOrMainPart.getMaterials().get(0);
        IMaterialDisplay main = mainMaterial.getDisplayProperties();
        MaterialLayer firstLayer = main.getLayerList(GearHelper.getType(gear), PartType.MAIN, mainMaterial).getFirstLayer();
        boolean highContrast = firstLayer == null || !firstLayer.getTextureId().toString().endsWith("lc");
        int n = ret = highContrast ? 3 : 2;
        if (GearData.getPartOfType(gear, PartType.TIP) != null) {
            ret |= 4;
        }
        if (GearData.getPartOfType(gear, PartType.GRIP) != null) {
            ret |= 8;
        }
        return ret;
    }

    @Nullable
    public static PartData getPrimaryPart(ItemStack stack) {
        return GearData.getPartOfType(stack, PartType.MAIN);
    }

    @Nullable
    public static MaterialInstance getPrimaryMainMaterial(ItemStack stack) {
        PartData part = GearData.getPrimaryPart(stack);
        if (part != null && part.get() instanceof CompoundPart) {
            return CompoundPartItem.getPrimaryMaterial(part.getItem());
        }
        return null;
    }

    @Nullable
    public static MaterialInstance getPrimaryArmorMaterial(ItemStack stack) {
        PartData coating = GearData.getPartOfType(stack, PartType.COATING);
        if (coating != null && coating.get() instanceof CompoundPart) {
            return CompoundPartItem.getPrimaryMaterial(coating.getItem());
        }
        return GearData.getPrimaryMainMaterial(stack);
    }

    @Nullable
    public static PartData getCoatingOrMainPart(ItemStack stack) {
        PartData coating = GearData.getPartOfType(stack, PartType.COATING);
        if (coating != null) {
            return coating;
        }
        return GearData.getPartOfType(stack, PartType.MAIN);
    }

    @Nullable
    public static PartData getPartOfType(ItemStack stack, PartType type) {
        CompoundTag tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListTag tagList = tags.m_128437_(NBT_CONSTRUCTION_PARTS, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbt = tagList.m_128728_(i);
            PartData part = PartData.read(nbt);
            if (part == null || part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOfType(ItemStack stack, PartType type) {
        CompoundTag tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListTag tagList = tags.m_128437_(NBT_CONSTRUCTION_PARTS, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbt = tagList.m_128728_(i);
            String key = nbt.m_128461_("ID");
            IGearPart part = PartManager.get(key);
            if (part == null || part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void addUpgradePart(ItemStack gear, PartData part) {
        if (!GearHelper.isGear(gear)) {
            return;
        }
        PartDataList parts = GearData.getConstructionParts(gear);
        if (!part.get().canAddToGear(gear, part)) {
            return;
        }
        if (part.get().replacesExistingInPosition(part)) {
            parts.removeIf(p -> p.getType() == part.getType());
        }
        part.onAddToGear(gear);
        for (PartData partInList : parts) {
            if (partInList.get() != part.get()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, PartType partType, Predicate<PartData> predicate) {
        for (PartData partData : GearData.getConstructionParts(gear)) {
            if (!predicate.test(partData)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, IGearPart part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    public static boolean hasPart(ItemStack gear, DataResource<IGearPart> part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    private static boolean hasPart(ItemStack gear, String partId) {
        CompoundTag tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        ListTag tagList = tags.m_128437_(NBT_CONSTRUCTION_PARTS, 10);
        for (Tag nbt : tagList) {
            CompoundTag partCompound;
            String partKey;
            if (!(nbt instanceof CompoundTag) || !(partKey = (partCompound = (CompoundTag)nbt).m_128461_("ID")).equals(partId)) continue;
            return true;
        }
        return false;
    }

    public static Optional<PartData> addOrReplacePart(ItemStack gear, PartData part) {
        PartType partType = part.getType();
        PartDataList parts = GearData.getConstructionParts(gear);
        List<PartData> partsOfType = parts.getPartsOfType(partType);
        PartData removedPart = null;
        if (!partsOfType.isEmpty() && partsOfType.size() >= partType.getMaxPerItem(GearHelper.getType(gear))) {
            removedPart = partsOfType.get(0);
            parts.remove(removedPart);
            removedPart.onRemoveFromGear(gear);
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        return Optional.ofNullable(removedPart);
    }

    public static void addPart(ItemStack gear, PartData part) {
        PartDataList parts = GearData.getConstructionParts(gear);
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        part.onAddToGear(gear);
    }

    public static boolean removeFirstPartOfType(ItemStack gear, PartType type) {
        PartDataList parts = GearData.getConstructionParts(gear);
        ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(type));
        if (!partsOfType.isEmpty()) {
            PartData removed = (PartData)partsOfType.remove(0);
            parts.remove(removed);
            GearData.writeConstructionParts(gear, parts);
            removed.onRemoveFromGear(gear);
            return true;
        }
        return false;
    }

    public static void removeExcessParts(ItemStack gear) {
        for (PartType type : PartType.getValues()) {
            GearData.removeExcessParts(gear, type);
        }
    }

    public static void removeExcessParts(ItemStack gear, PartType partType) {
        PartDataList parts = GearData.getConstructionParts(gear);
        ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(partType));
        int maxCount = partType.getMaxPerItem(GearHelper.getType(gear));
        int removed = 0;
        while (partsOfType.size() > maxCount) {
            PartData toRemove = (PartData)partsOfType.get(0);
            partsOfType.remove(toRemove);
            parts.remove(toRemove);
            toRemove.onRemoveFromGear(gear);
            ++removed;
            SilentGear.LOGGER.debug("Removed excess part '{}' from '{}'", (Object)toRemove.getDisplayName(gear).getString(), (Object)gear.m_41786_().getString());
        }
        if (removed > 0) {
            GearData.writeConstructionParts(gear, parts);
        }
    }

    public static void writeConstructionParts(ItemStack gear, Collection<? extends IPartData> parts) {
        if (GearData.checkNonGearItem(gear, "writeConstructionParts")) {
            return;
        }
        CompoundTag tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        ListTag tagList = new ListTag();
        parts.stream().filter(p -> p.getType() == PartType.MAIN).map(p -> p.write(new CompoundTag())).forEach(arg_0 -> tagList.add(arg_0));
        parts.stream().filter(p -> p.getType() != PartType.MAIN).map(p -> p.write(new CompoundTag())).forEach(arg_0 -> tagList.add(arg_0));
        tags.m_128365_(NBT_CONSTRUCTION_PARTS, (Tag)tagList);
    }

    public static UUID getUUID(ItemStack gear) {
        if (GearData.checkNonGearItem(gear, "getUUID")) {
            return new UUID(0L, 0L);
        }
        CompoundTag tags = gear.m_41784_();
        if (!tags.m_128403_(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tags.m_128362_(NBT_UUID, uuid);
            return uuid;
        }
        return tags.m_128342_(NBT_UUID);
    }

    private static CompoundTag getData(ItemStack gear, String compoundKey) {
        if (GearData.checkNonGearItem(gear, "getData")) {
            return new CompoundTag();
        }
        CompoundTag rootTag = gear.m_41698_(NBT_ROOT);
        if (!rootTag.m_128441_(compoundKey)) {
            rootTag.m_128365_(compoundKey, (Tag)new CompoundTag());
        }
        return rootTag.m_128469_(compoundKey);
    }

    static CompoundTag getPropertiesData(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES);
    }

    static CompoundTag getStatisticsCompound(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_STATISTICS);
    }

    public static void setExampleTag(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128379_(NBT_IS_EXAMPLE, value);
    }

    public static boolean isExampleGear(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128471_(NBT_IS_EXAMPLE);
    }

    @Deprecated
    public static boolean isRandomGradingDone(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128471_("RandomGradingDone");
    }

    @Deprecated
    static void setRandomGradingDone(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128379_("RandomGradingDone", value);
    }

    public static int getBrokenCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128451_(NBT_BROKEN_COUNT);
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128405_(NBT_BROKEN_COUNT, GearData.getBrokenCount(stack) + 1);
    }

    public static int getRepairCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128451_(NBT_REPAIR_COUNT);
    }

    public static void incrementRepairCount(ItemStack stack, int amount) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).m_128405_(NBT_REPAIR_COUNT, GearData.getRepairCount(stack) + amount);
    }

    private static boolean checkNonGearItem(ItemStack stack, String methodName) {
        if (GearHelper.isGear(stack)) {
            return false;
        }
        SilentGear.LOGGER.error("Called {} on non-gear item, {}", (Object)methodName, (Object)stack);
        SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
        return true;
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            StackList.from((Container)player.m_150109_()).stream().filter(s -> s.m_41720_() instanceof ICoreItem).forEach(s -> GearData.recalculateStats(s, player));
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.getEquippedCurios((LivingEntity)player).forEach(s -> GearData.recalculateStats(s, player));
            }
        }
    }
}

