/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;

public class ExtendedSingleItemRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Ingredient ingredients;
    private final Item result;
    private final int count;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    protected ExtendedSingleItemRecipeBuilder(RecipeSerializer<?> serializer, Ingredient ingredients, ItemLike result, int count) {
        this.serializer = serializer;
        this.ingredients = ingredients;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ExtendedSingleItemRecipeBuilder builder(RecipeSerializer<?> serializer, Ingredient ingredient, ItemLike result) {
        return ExtendedSingleItemRecipeBuilder.builder(serializer, ingredient, result, 1);
    }

    public static ExtendedSingleItemRecipeBuilder builder(RecipeSerializer<?> serializer, Ingredient ingredient, ItemLike result, int count) {
        return new ExtendedSingleItemRecipeBuilder(serializer, ingredient, result, count);
    }

    public static ExtendedSingleItemRecipeBuilder stonecuttingBuilder(Ingredient ingredient, ItemLike result) {
        return ExtendedSingleItemRecipeBuilder.stonecuttingBuilder(ingredient, result, 1);
    }

    public static ExtendedSingleItemRecipeBuilder stonecuttingBuilder(Ingredient ingredient, ItemLike result, int count) {
        return new ExtendedSingleItemRecipeBuilder(RecipeSerializer.f_44095_, ingredient, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedSingleItemRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedSingleItemRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedSingleItemRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        ResourceLocation itemId = NameUtils.fromItem((ItemLike)this.result);
        ResourceLocation serializerId = NameUtils.fromRecipeSerializer(this.serializer);
        this.build(consumer, new ResourceLocation(itemId.m_135827_(), serializerId.m_135815_() + "/" + itemId.m_135815_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasAdvancementCriterion && !this.advancementBuilder.m_138405_().isEmpty()) {
            this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + id.m_135815_());
        consumer.accept(new Result(id, this, advancementId));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedSingleItemRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedSingleItemRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            json.add("ingredient", this.builder.ingredients.m_43942_());
            json.addProperty("result", NameUtils.fromItem((ItemLike)this.builder.result).toString());
            json.addProperty("count", (Number)this.builder.count);
            this.builder.serializeExtra(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

