/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.lib.util.DimensionId;

public final class DimPos {
    public static final DimPos ZERO = new DimPos(0, 0, 0, (ResourceKey<Level>)Level.f_46428_);
    private final int posX;
    private final int posY;
    private final int posZ;
    private final DimensionId dimension;

    public static DimPos of(BlockPos pos, ResourceKey<Level> dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, ResourceKey<Level> dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.m_20183_(), (ResourceKey<Level>)entity.f_19853_.m_46472_());
    }

    private DimPos(BlockPos pos, ResourceKey<Level> dimension) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dimension);
    }

    private DimPos(int x, int y, int z, ResourceKey<Level> dimension) {
        this(x, y, z, DimensionId.fromId(dimension));
    }

    private DimPos(int x, int y, int z, DimensionId dimension) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getZ() {
        return this.posZ;
    }

    public DimensionId getDimensionId() {
        return this.dimension;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension.getId();
    }

    public static DimPos read(CompoundTag tags) {
        return DimPos.of(tags.m_128451_("posX"), tags.m_128451_("posY"), tags.m_128451_("posZ"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tags.m_128461_("dim"))));
    }

    public void write(CompoundTag tags) {
        tags.m_128405_("posX", this.posX);
        tags.m_128405_("posY", this.posY);
        tags.m_128405_("posZ", this.posZ);
        tags.m_128359_("dim", this.dimension.getRegistryName().toString());
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public Vec3 getPosCentered(double yOffset) {
        return new Vec3((double)this.posX + 0.5, (double)this.posY + yOffset, (double)this.posZ + 0.5);
    }

    public DimPos offset(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.m_122429_() * n, this.posY + facing.m_122430_() * n, this.posZ + facing.m_122431_() * n, this.dimension);
    }

    public String toString() {
        return String.format("(%d, %d, %s) in %s", this.posX, this.posY, this.posZ, this.dimension.getRegistryName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DimPos)) {
            return false;
        }
        DimPos pos = (DimPos)other;
        return pos.dimension == this.dimension && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension.getRegistryName().hashCode();
    }
}

