/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.SideIOContainer;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.IOMode;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeWrapper;

public class HopperUpgradeContainer
extends UpgradeContainerBase<HopperUpgradeWrapper, HopperUpgradeContainer> {
    public static final Pair<ResourceLocation, ResourceLocation> EMPTY_INPUT_FILTER_SLOT_BACKGROUND = new Pair((Object)InventoryMenu.f_39692_, (Object)SophisticatedStorage.getRL("item/empty_input_filter_slot"));
    public static final Pair<ResourceLocation, ResourceLocation> EMPTY_OUTPUT_FILTER_SLOT_BACKGROUND = new Pair((Object)InventoryMenu.f_39692_, (Object)SophisticatedStorage.getRL("item/empty_output_filter_slot"));
    private final ContentsFilterLogicContainer inputFilterLogicContainer = new ContentsFilterLogicContainer(upgradeWrapper::getInputFilterLogic, (IServerUpdater)this, this::addInputFilterSlot);
    private final ContentsFilterLogicContainer outputFilterLogicContainer = new ContentsFilterLogicContainer(upgradeWrapper::getOutputFilterLogic, (IServerUpdater)this, this::addOutputFilterSlot);
    private final SideIOContainer sideIOContainer = new SideIOContainer((IServerUpdater)this, this::getHorizontalDirection, this::getVerticalFacing, this::getDirectionIOMode, this::setDirectionIOMode, false);
    @Nullable
    private Direction horizontalDirection;
    @Nullable
    private VerticalFacing verticalFacing;

    public HopperUpgradeContainer(Player player, int upgradeContainerId, HopperUpgradeWrapper upgradeWrapper, UpgradeContainerType<HopperUpgradeWrapper, HopperUpgradeContainer> type) {
        super(player, upgradeContainerId, (IUpgradeWrapper)upgradeWrapper, type);
    }

    private void addInputFilterSlot(Slot slot) {
        slot.setBackground((ResourceLocation)EMPTY_INPUT_FILTER_SLOT_BACKGROUND.getFirst(), (ResourceLocation)EMPTY_INPUT_FILTER_SLOT_BACKGROUND.getSecond());
        this.slots.add(slot);
    }

    private void addOutputFilterSlot(Slot slot) {
        slot.setBackground((ResourceLocation)EMPTY_OUTPUT_FILTER_SLOT_BACKGROUND.getFirst(), (ResourceLocation)EMPTY_OUTPUT_FILTER_SLOT_BACKGROUND.getSecond());
        this.slots.add(slot);
    }

    private Direction getHorizontalDirection() {
        if (this.horizontalDirection == null) {
            this.initBlockRotation();
        }
        return this.horizontalDirection;
    }

    private VerticalFacing getVerticalFacing() {
        if (this.verticalFacing == null) {
            this.initBlockRotation();
        }
        return this.verticalFacing;
    }

    private void initBlockRotation() {
        this.horizontalDirection = Direction.NORTH;
        this.verticalFacing = VerticalFacing.NO;
        AbstractContainerMenu abstractContainerMenu = this.player.f_36096_;
        if (abstractContainerMenu instanceof StorageContainerMenuBase) {
            StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
            storageContainerMenu.getBlockPosition().ifPresent(pos -> {
                BlockState state = this.player.f_19853_.m_8055_(pos);
                Block patt3570$temp = state.m_60734_();
                if (patt3570$temp instanceof StorageBlockBase) {
                    StorageBlockBase storageBlock = (StorageBlockBase)patt3570$temp;
                    this.horizontalDirection = storageBlock.getHorizontalDirection(state);
                    this.verticalFacing = storageBlock.getVerticalFacing(state);
                }
            });
        }
    }

    private void setDirectionIOMode(Direction direction, IOMode ioMode) {
        switch (ioMode) {
            case OFF: {
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPullingFrom(direction, false);
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPushingTo(direction, false);
                break;
            }
            case PUSH: {
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPullingFrom(direction, false);
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPushingTo(direction, true);
                break;
            }
            case PULL: {
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPullingFrom(direction, true);
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPushingTo(direction, false);
                break;
            }
            case PUSH_PULL: {
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPullingFrom(direction, true);
                ((HopperUpgradeWrapper)this.upgradeWrapper).setPushingTo(direction, true);
            }
        }
    }

    private IOMode getDirectionIOMode(Direction direction) {
        boolean pulling = ((HopperUpgradeWrapper)this.upgradeWrapper).isPullingFrom(direction);
        boolean pushing = ((HopperUpgradeWrapper)this.upgradeWrapper).isPushingTo(direction);
        if (pulling && pushing) {
            return IOMode.PUSH_PULL;
        }
        if (pulling) {
            return IOMode.PULL;
        }
        if (pushing) {
            return IOMode.PUSH;
        }
        return IOMode.OFF;
    }

    public void handleMessage(CompoundTag data) {
        this.inputFilterLogicContainer.handleMessage(data);
        this.outputFilterLogicContainer.handleMessage(data);
        this.sideIOContainer.handleMessage(data);
    }

    public ContentsFilterLogicContainer getInputFilterLogicContainer() {
        return this.inputFilterLogicContainer;
    }

    public ContentsFilterLogicContainer getOutputFilterLogicContainer() {
        return this.outputFilterLogicContainer;
    }

    public SideIOContainer getSideIOContainer() {
        return this.sideIOContainer;
    }
}

