/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.mixin;

import me.codexadrian.spirit.EngulfableItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements EngulfableItem {
    int engulfTime = 0;
    int maxEngulfTime = 0;
    private static final EntityDataAccessor<Boolean> RECIPE_OUTPUT = SynchedEntityData.m_135353_(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ENGULF_TIME = SynchedEntityData.m_135353_(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_ENGULF_TIME = SynchedEntityData.m_135353_(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineCorrupted(CallbackInfo ci) {
        SynchedEntityData entityData = ((ItemEntity)this).m_20088_();
        entityData.m_135372_(RECIPE_OUTPUT, (Object)false);
        entityData.m_135372_(ENGULF_TIME, (Object)0);
        entityData.m_135372_(MAX_ENGULF_TIME, (Object)0);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCorrupted(CompoundTag compoundTag, CallbackInfo ci) {
        SynchedEntityData entityData = ((ItemEntity)this).m_20088_();
        entityData.m_135381_(RECIPE_OUTPUT, (Object)compoundTag.m_128471_("isRecipeOutput"));
        this.engulfTime = compoundTag.m_128451_("EngulfTime");
        this.engulfTime = compoundTag.m_128451_("MaxEngulfTime");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void saveCorrupted(CompoundTag compoundTag, CallbackInfo ci) {
        SynchedEntityData entityData = ((ItemEntity)this).m_20088_();
        compoundTag.m_128379_("IsRecipeOutput", ((Boolean)entityData.m_135370_(RECIPE_OUTPUT)).booleanValue());
        compoundTag.m_128405_("EngulfTime", this.engulfTime);
        compoundTag.m_128405_("MaxEngulfTime", this.maxEngulfTime);
    }

    @Override
    public void resetEngulfing() {
        this.engulfTime = 0;
        this.maxEngulfTime = 0;
    }

    @Override
    public void setMaxEngulfTime(int duration) {
        this.maxEngulfTime = duration;
    }

    @Override
    public boolean isEngulfed() {
        return this.engulfTime >= 0 && this.maxEngulfTime != 0;
    }

    @Override
    public boolean isFullyEngulfed() {
        return this.engulfTime >= this.maxEngulfTime;
    }

    @Override
    public boolean isRecipeOutput() {
        SynchedEntityData entityData = ((ItemEntity)this).m_20088_();
        return (Boolean)entityData.m_135370_(RECIPE_OUTPUT);
    }

    @Override
    public void setRecipeOutput() {
        SynchedEntityData entityData = ((ItemEntity)this).m_20088_();
        entityData.m_135381_(RECIPE_OUTPUT, (Object)true);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        if (this.isEngulfed() && !itemEntity.f_19853_.m_5776_()) {
            if (this.engulfTime % 5 == 0) {
                ServerLevel sLevel = (ServerLevel)itemEntity.f_19853_;
                sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
                sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
            }
            ++this.engulfTime;
        }
    }
}

