/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.SpiritConfig;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.registry.SpiritMisc;
import me.codexadrian.spirit.utils.forge.SoulUtilsImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class SoulUtils {
    @Nullable
    public static Tier getTier(ItemStack itemStack, Level level) {
        if (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_("StoredEntity")) {
            return null;
        }
        return Tier.getTier(SoulUtils.getSoulsInCrystal(itemStack), SoulUtils.getSoulCrystalType(itemStack), level);
    }

    public static String getTierDisplay(ItemStack itemStack, Level level) {
        Tier tier = SoulUtils.getTier(itemStack, level);
        return tier == null ? SpiritConfig.getInitialTierName() : tier.displayName();
    }

    @Contract(pure=true)
    @Nullable
    public static Tier getNextTier(ItemStack itemStack, Level level) {
        if (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_("StoredEntity")) {
            return null;
        }
        return Tier.getTier(SoulUtils.getSoulsInCrystal(itemStack), SoulUtils.getSoulCrystalType(itemStack), level, true);
    }

    public static int getMaxSouls(ItemStack itemStack, Level level) {
        if (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_("StoredEntity")) {
            return Integer.MAX_VALUE;
        }
        Tier maxTier = Tier.getHighestTier(SoulUtils.getSoulCrystalType(itemStack), level);
        return maxTier == null ? Integer.MAX_VALUE : maxTier.requiredSouls();
    }

    public static int getSoulsInCrystal(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            if (itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
                return itemStack.m_41783_().m_128469_("StoredEntity").m_128451_("Souls");
            }
            if (itemStack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get())) {
                return itemStack.m_41783_().m_128451_("Souls");
            }
            if (itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
                return itemStack.m_41783_().m_128441_("EntityType") ? 1 : 0;
            }
        }
        return 0;
    }

    public static boolean canCrystalAcceptSoul(ItemStack crystal, @Nullable LivingEntity victim) {
        if (victim == null) {
            return SoulUtils.canCrystalAcceptSoul(crystal, null, null);
        }
        return SoulUtils.canCrystalAcceptSoul(crystal, victim.m_9236_(), victim.m_6095_());
    }

    public static boolean canCrystalAcceptSoul(ItemStack crystal, @Nullable Level level, @Nullable EntityType<?> type) {
        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
            if (type == null) {
                return false;
            }
            if (crystal.m_41783_() != null) {
                boolean isCorrectType = Registry.f_122826_.m_7981_(type).toString().equals(SoulUtils.getSoulCrystalType(crystal));
                boolean hasRoomForMore = SoulUtils.getSoulsInCrystal(crystal) < SoulUtils.getMaxSouls(crystal, level);
                return isCorrectType && hasRoomForMore;
            }
            return !type.equals(SpiritMisc.SOUL_ENTITY.get());
        }
        if (crystal.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get())) {
            return SoulUtils.getSoulsInCrystal(crystal) < SpiritConfig.getCrudeSoulCrystalCap();
        }
        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
            return SoulUtils.getSoulCrystalType(crystal) == null;
        }
        return false;
    }

    public static boolean doCrystalTypesMatch(ItemStack crystal1, ItemStack crystal2) {
        return Objects.equals(SoulUtils.getSoulCrystalType(crystal1), SoulUtils.getSoulCrystalType(crystal2));
    }

    @Nullable
    public static String getSoulCrystalType(ItemStack crystal) {
        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
            if (crystal.m_41783_() != null) {
                String string = crystal.m_41783_().m_128469_("StoredEntity").m_128461_("Type");
                return string.isBlank() ? null : string;
            }
            return null;
        }
        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
            if (crystal.m_41783_() != null) {
                String string = crystal.m_41783_().m_128461_("EntityType");
                return string.isBlank() ? null : string;
            }
            return null;
        }
        return null;
    }

    public static ItemStack findCrystal(Player player, @Nullable LivingEntity victim, boolean mustContainSouls, boolean mustBeSoulCrystal, boolean canFindMobCrystal) {
        ItemStack returnStack = SoulUtils.searchTrinkets(player, victim);
        if (returnStack.m_41619_() && canFindMobCrystal) {
            returnStack = SoulUtils.getMobCrystal(player.m_6167_());
        }
        if (returnStack.m_41619_()) {
            returnStack = SoulUtils.getSoulCrystal(player.m_6167_(), victim, mustContainSouls);
        }
        if (returnStack.m_41619_() && !mustBeSoulCrystal) {
            returnStack = SoulUtils.getCrudeSoulCrystal(player.m_6167_(), mustContainSouls);
        }
        if (returnStack.m_41619_() && canFindMobCrystal) {
            returnStack = SoulUtils.getMobCrystal((Iterable<ItemStack>)player.m_150109_().f_35974_);
        }
        if (returnStack.m_41619_()) {
            returnStack = SoulUtils.getSoulCrystal((Iterable<ItemStack>)player.m_150109_().f_35974_, victim, mustContainSouls);
        }
        if (returnStack.m_41619_() && !mustBeSoulCrystal) {
            returnStack = SoulUtils.getCrudeSoulCrystal((Iterable<ItemStack>)player.m_150109_().f_35974_, mustContainSouls);
        }
        return returnStack;
    }

    public static ItemStack findCrystal(Player player, @Nullable LivingEntity victim, boolean mustContainSouls) {
        return SoulUtils.findCrystal(player, victim, mustContainSouls, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack searchTrinkets(Player player, @Nullable LivingEntity victim) {
        void var1_1;
        return SoulUtilsImpl.searchTrinkets(player, (LivingEntity)var1_1);
    }

    public static ItemStack getSoulCrystal(Iterable<ItemStack> inventory, @Nullable LivingEntity victim, boolean mustContainSouls) {
        ItemStack savedStack = ItemStack.f_41583_;
        int savedSouls = 0;
        for (ItemStack currentItem : inventory) {
            int souls;
            if (!currentItem.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) || SoulUtils.getSoulsInCrystal(currentItem) == 0 && mustContainSouls) continue;
            if (victim == null) {
                return currentItem;
            }
            if (!SoulUtils.canCrystalAcceptSoul(currentItem, victim)) continue;
            if (savedStack.m_41619_()) {
                savedStack = currentItem;
                continue;
            }
            if (currentItem.m_41783_() == null || (souls = SoulUtils.getSoulsInCrystal(currentItem)) <= savedSouls) continue;
            savedStack = currentItem;
            savedSouls = souls;
        }
        return savedStack;
    }

    public static ItemStack getCrudeSoulCrystal(Iterable<ItemStack> inventory, boolean mustContainSouls) {
        ItemStack savedStack = ItemStack.f_41583_;
        int savedSouls = 0;
        for (ItemStack currentItem : inventory) {
            if (!currentItem.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) || SoulUtils.getSoulsInCrystal(currentItem) == 0 && mustContainSouls || !SoulUtils.canCrystalAcceptSoul(currentItem, null)) continue;
            int soulsInCrystal = SoulUtils.getSoulsInCrystal(currentItem);
            if (!savedStack.m_41619_() && soulsInCrystal <= savedSouls) continue;
            savedStack = currentItem;
            savedSouls = soulsInCrystal;
        }
        return savedStack;
    }

    public static ItemStack getMobCrystal(Iterable<ItemStack> inventory) {
        ItemStack savedStack = ItemStack.f_41583_;
        for (ItemStack currentItem : inventory) {
            if (!currentItem.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get()) || !savedStack.m_41619_() || SoulUtils.getSoulCrystalType(currentItem) != null) continue;
            savedStack = currentItem;
        }
        return savedStack;
    }

    public static void handleMobCrystal(ItemStack mobCrystal, Player player, LivingEntity victim) {
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoulUtils.deviateSoulCount(mobCrystal, 1, player.f_19853_, Registry.f_122826_.m_7981_((Object)victim.m_6095_()).toString());
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 20, (double)victim.m_20205_(), (double)victim.m_20206_(), (double)victim.m_20205_(), 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 40, 1.0, 2.0, 1.0, 0.0);
        }
    }

    public static void handleSoulCrystal(ItemStack soulCrystal, Player player, LivingEntity victim) {
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            CompoundTag storedEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (soulCrystal.m_41783_() == null || !soulCrystal.m_41783_().m_128441_("StoredEntity")) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Type", Registry.f_122826_.m_7981_((Object)victim.m_6095_()).toString());
                soulCrystal.m_41784_().m_128365_("StoredEntity", (Tag)tag);
                storedEntity = tag;
            } else {
                storedEntity = soulCrystal.m_41783_().m_128469_("StoredEntity");
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 20, (double)victim.m_20205_(), (double)victim.m_20206_(), (double)victim.m_20205_(), 0.0);
            Tier tier = SoulUtils.getNextTier(soulCrystal, (Level)serverLevel);
            int incrementAmount = SoulUtils.getSoulHarvestAmount(player);
            if (tier != null && storedEntity.m_128451_("Souls") + incrementAmount >= tier.requiredSouls()) {
                player.m_5661_((Component)Component.m_237115_((String)"item.spirit.soul_crystal.upgrade_message").m_130940_(ChatFormatting.AQUA), true);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 40, 1.0, 2.0, 1.0, 0.0);
            }
            storedEntity.m_128405_("Souls", storedEntity.m_128451_("Souls") + incrementAmount);
        }
    }

    public static void deviateSoulCount(ItemStack stack, int deviation, Level level, @Nullable String mobType) {
        if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
            if (deviation < 0) {
                stack.m_41784_().m_128473_("EntityType");
            } else if (mobType != null && deviation > 0) {
                stack.m_41784_().m_128359_("EntityType", mobType);
            }
            return;
        }
        if (stack.m_41783_() != null) {
            if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
                CompoundTag storedEntity = stack.m_41783_().m_128469_("StoredEntity");
                storedEntity.m_128405_("Souls", Mth.m_14045_((int)(SoulUtils.getSoulsInCrystal(stack) + deviation), (int)0, (int)SoulUtils.getMaxSouls(stack, level)));
                if (storedEntity.m_128451_("Souls") == 0) {
                    stack.m_41751_(null);
                }
            } else if (stack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get())) {
                stack.m_41783_().m_128405_("Souls", Mth.m_14045_((int)(SoulUtils.getSoulsInCrystal(stack) + deviation), (int)0, (int)SpiritConfig.getCrudeSoulCrystalCap()));
                if (stack.m_41783_().m_128451_("Souls") == 0) {
                    stack.m_41751_(null);
                }
            }
        } else if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && mobType != null && deviation > 0) {
            CompoundTag storedEntity = new CompoundTag();
            storedEntity.m_128359_("Type", mobType);
            storedEntity.m_128405_("Souls", deviation);
            stack.m_41784_().m_128365_("StoredEntity", (Tag)storedEntity);
        } else if (stack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) && deviation > 0) {
            stack.m_41784_().m_128405_("Souls", Math.min(deviation, SpiritConfig.getCrudeSoulCrystalCap()));
        } else if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get()) && deviation > 0 && mobType != null) {
            stack.m_41784_().m_128359_("EntityType", mobType);
        }
    }

    public static void handleCrudeSoulCrystal(ItemStack crudeCrystal, Player player, LivingEntity victim) {
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 20, (double)victim.m_20205_(), (double)victim.m_20206_(), (double)victim.m_20205_(), 0.0);
            crudeCrystal.m_41784_().m_128405_("Souls", Math.min(SoulUtils.getSoulsInCrystal(crudeCrystal) + SoulUtils.getSoulHarvestAmount(player), SpiritConfig.getCrudeSoulCrystalCap()));
        }
    }

    public static int getSoulHarvestAmount(Player player) {
        int returnAmount = 1;
        if (player.m_21205_().m_204117_(Spirit.SOUL_STEEL_MAINHAND) || player.m_21206_().m_204117_(Spirit.SOUL_STEEL_OFFHAND)) {
            ++returnAmount;
        }
        return returnAmount + EnchantmentHelper.m_44836_((Enchantment)SpiritMisc.SOUL_REAPER_ENCHANTMENT.get(), (LivingEntity)player);
    }

    public static boolean isAllowed(ItemStack crystal, TagKey<EntityType<?>> blacklistTag) {
        String entityTypeName = SoulUtils.getSoulCrystalType(crystal);
        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && entityTypeName != null) {
            return EntityType.m_20632_((String)entityTypeName).map(entityType -> !entityType.m_204039_(blacklistTag)).orElse(false);
        }
        return false;
    }

    public static boolean canCrystalBeUsedInCage(ItemStack crystal) {
        return SoulUtils.isAllowed(crystal, Spirit.BLACKLISTED_TAG);
    }
}

