/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.core.SGAccessor;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class GridStructurePlacement
extends StructurePlacement {
    private static final Map<ResourceLocation, StructureConfig> CONFIGS = new HashMap<ResourceLocation, StructureConfig>();
    public static final Codec<GridStructurePlacement> CODEC = RecordCodecBuilder.create(instance -> {
        Products.P5 placement = GridStructurePlacement.m_227041_((RecordCodecBuilder.Instance)instance);
        return instance.group((App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(o -> o.structureName), placement.t1(), (App)TaggedExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(o -> o.taggedExclusionZone), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(GridStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("offset").forGetter(GridStructurePlacement::offset), placement.t3(), placement.t4(), (App)Codec.BOOL.fieldOf("allowed_near_spawn").forGetter(GridStructurePlacement::allowedNearSpawn)).apply((Applicative)instance, GridStructurePlacement::new);
    });
    private final ResourceLocation structureName;
    protected ModifiableData modifiableData;
    private final Optional<TaggedExclusionZone> taggedExclusionZone;
    @Nullable
    private final StructureConfig config;

    private GridStructurePlacement(ResourceLocation structureName, Vec3i locateOffset, Optional<TaggedExclusionZone> exclusionZone, int spacing, int offset, float probability, int seed, boolean allowedNearSpawn) {
        super(locateOffset, StructurePlacement.FrequencyReductionMethod.DEFAULT, probability, seed, Optional.empty());
        this.structureName = structureName;
        this.taggedExclusionZone = exclusionZone;
        this.config = CONFIGS.get(structureName);
        if (this.config == null) {
            this.modifiableData = new ModifiableData(probability, seed, spacing, offset, allowedNearSpawn);
        } else {
            StructureConfig.PlacementConfig place = this.config.getPlacement();
            this.modifiableData = new ModifiableData(place.getProbability(probability).floatValue(), seed, place.getSpacing(spacing), place.getOffset(offset), place.isAllowedNearSpawn(allowedNearSpawn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridStructurePlacement(ResourceLocation structureName, Vec3i locateOffset, Optional<TaggedExclusionZone> exclusionZone, int spacing, int offset, float probability, int seed, boolean allowedNearSpawn, @Nullable StructureConfig config) {
        super(locateOffset, StructurePlacement.FrequencyReductionMethod.DEFAULT, probability, seed, Optional.empty());
        this.structureName = structureName;
        this.modifiableData = new ModifiableData(probability, seed, spacing, offset, allowedNearSpawn);
        this.taggedExclusionZone = exclusionZone;
        this.config = config;
        Map<ResourceLocation, StructureConfig> map = CONFIGS;
        synchronized (map) {
            if (CONFIGS.putIfAbsent(structureName, config) != null) {
                throw new IllegalArgumentException("[Structure Gel] A placement config already has been bound to " + structureName);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int spacing, float probability) {
        return GridStructurePlacement.builder().spacing(spacing).offset(spacing - 1).probability(probability);
    }

    public static Builder builder(int spacing, int offset, float probability) {
        return GridStructurePlacement.builder(spacing, probability).offset(offset);
    }

    public boolean m_227054_(ChunkGenerator chunkGen, RandomState randomState, long levelSeed, int chunkX, int chunkZ) {
        return this.m_214090_(chunkGen, randomState, levelSeed, chunkX, chunkZ) && (!this.taggedExclusionZone.isPresent() || !this.taggedExclusionZone.get().isPlacementForbidden(chunkGen, randomState, levelSeed, chunkX, chunkZ));
    }

    protected boolean m_214090_(ChunkGenerator chunkGen, RandomState randomState, long levelSeed, int chunkX, int chunkZ) {
        Optional<ChunkPos> opGenPos = this.getFeatureChunk(chunkGen, levelSeed, chunkX, chunkZ);
        if (opGenPos.isPresent()) {
            ChunkPos genPos = opGenPos.get();
            return genPos.f_45578_ == chunkX && genPos.f_45579_ == chunkZ;
        }
        return false;
    }

    public Optional<ChunkPos> getFeatureChunk(ChunkGenerator chunkGen, long levelSeed, int chunkX, int chunkZ) {
        if (this.m_227074_() > 0.0f) {
            int spacing = this.spacing();
            int gridX = (int)Math.floor((float)chunkX / (float)spacing) * spacing;
            int gridZ = (int)Math.floor((float)chunkZ / (float)spacing) * spacing;
            int offset = this.offset() + 1;
            WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
            rand.m_190058_(levelSeed, gridX, gridZ, this.m_227075_());
            ChunkPos genPos = new ChunkPos(gridX + rand.m_188503_(offset), gridZ + rand.m_188503_(offset));
            if ((this.allowedNearSpawn() || !this.isNearSpawn(genPos)) && (this.m_227074_() >= 1.0f || this.probabilityTest(genPos, levelSeed))) {
                return Optional.of(genPos);
            }
        }
        return Optional.empty();
    }

    protected boolean isNearSpawn(ChunkPos genPos) {
        int range = 12;
        return genPos.f_45578_ < range && genPos.f_45578_ > -range && genPos.f_45579_ < range && genPos.f_45579_ > -range;
    }

    protected boolean probabilityTest(ChunkPos genPos, long levelSeed) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
        rand.m_190058_(levelSeed, genPos.f_45578_, genPos.f_45579_, this.m_227075_());
        return rand.m_188501_() < this.m_227074_();
    }

    protected float m_227074_() {
        return this.modifiableData.probability;
    }

    protected int m_227075_() {
        return this.modifiableData.seed;
    }

    protected int spacing() {
        return this.modifiableData.spacing;
    }

    protected int offset() {
        return this.modifiableData.offset;
    }

    protected boolean allowedNearSpawn() {
        return this.modifiableData.allowedNearSpawn;
    }

    public StructurePlacementType<?> m_203443_() {
        return SGRegistry.StructurePlacementTypes.GRID_PLACEMENT.get();
    }

    @Nullable
    @Internal
    private Pair<BlockPos, Holder<Structure>> findNearest(Set<Holder<Structure>> structures, ServerLevel level, ChunkGenerator chunkGen, StructureManager structureManager, int x, int z, int radius, boolean skipKnown) {
        int spacing = this.spacing();
        for (int dx = -radius; dx <= radius; ++dx) {
            boolean flag = dx == -radius || dx == radius;
            for (int dz = -radius; dz <= radius; ++dz) {
                boolean flag1;
                boolean bl = flag1 = dz == -radius || dz == radius;
                if (!flag && !flag1) continue;
                int cx = x + spacing * dx;
                int cz = z + spacing * dz;
                Optional<ChunkPos> opGenPos = this.getFeatureChunk(chunkGen, level.m_7328_(), cx, cz);
                if (!opGenPos.isPresent()) continue;
                ChunkPos genPos = opGenPos.get();
                for (Holder<Structure> holder : structures) {
                    StructureCheckResult result = structureManager.m_220473_(genPos, (Structure)holder.m_203334_(), skipKnown);
                    if (result == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!skipKnown && result == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)this.m_227039_(genPos), holder);
                    }
                    ChunkAccess chunkAccess = level.m_46819_(genPos.f_45578_, genPos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart start = structureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)chunkAccess), (Structure)holder.m_203334_(), (StructureAccess)chunkAccess);
                    if (start == null || !start.m_73603_()) continue;
                    if (skipKnown) {
                        if (!start.m_73606_()) continue;
                        structureManager.m_220484_(start);
                        return Pair.of((Object)this.m_227039_(start.m_163625_()), holder);
                    }
                    return Pair.of((Object)this.m_227039_(start.m_163625_()), holder);
                }
            }
        }
        return null;
    }

    @Nullable
    @Internal
    public static Pair<BlockPos, Holder<Structure>> findNearesStructure(ServerLevel level, HolderSet<Structure> structureHolders, BlockPos origin, int radius, boolean skipKnown, ChunkGenerator chunkGen, @Nullable Pair<BlockPos, Holder<Structure>> oldNearest) {
        Set biomeSourceBiomes;
        Set structureBiomes = structureHolders.m_203614_().flatMap(csf -> ((Structure)csf.m_203334_()).m_226559_().m_203614_()).collect(Collectors.toSet());
        if (!structureBiomes.isEmpty() && !Collections.disjoint(biomeSourceBiomes = chunkGen.m_62218_().m_207840_(), structureBiomes)) {
            Pair<BlockPos, Holder<Structure>> newNearest = null;
            Object2ObjectArrayMap structuresByPlacement = new Object2ObjectArrayMap();
            for (Holder holder : structureHolders) {
                if (biomeSourceBiomes.stream().noneMatch(arg_0 -> ((HolderSet)((Structure)holder.m_203334_()).m_226559_()).m_203333_(arg_0))) continue;
                for (StructurePlacement structureplacement : SGAccessor.CHUNK_GENERATOR_GET_PLACEMENTS.invoke(chunkGen, holder, level.m_7726_().m_214994_())) {
                    structuresByPlacement.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
                }
            }
            block2: for (Map.Entry entry : structuresByPlacement.entrySet()) {
                StructurePlacement placement2 = (StructurePlacement)entry.getKey();
                if (!(placement2 instanceof GridStructurePlacement)) continue;
                GridStructurePlacement gelPlacement = (GridStructurePlacement)placement2;
                int originCX = SectionPos.m_123171_((int)origin.m_123341_());
                int originCZ = SectionPos.m_123171_((int)origin.m_123343_());
                for (int r = 0; r <= radius; ++r) {
                    Pair<BlockPos, Holder<Structure>> found = gelPlacement.findNearest((Set)entry.getValue(), level, chunkGen, level.m_215010_(), originCX, originCZ, r, skipKnown);
                    if (found == null) continue;
                    newNearest = found;
                    continue block2;
                }
            }
            if (oldNearest == null) {
                return newNearest;
            }
            if (newNearest != null) {
                double oldDist = origin.m_123331_((Vec3i)oldNearest.getFirst());
                double newDist = origin.m_123331_((Vec3i)newNearest.getFirst());
                if (newDist < oldDist) {
                    return newNearest;
                }
            }
        }
        return oldNearest;
    }

    public record ModifiableData(float probability, int seed, int spacing, int offset, boolean allowedNearSpawn) {
        public ModifiableData(float probability, int seed, int spacing, int offset, boolean allowedNearSpawn) {
            this.probability = probability;
            this.seed = seed;
            this.spacing = spacing;
            this.offset = Mth.m_14045_((int)offset, (int)0, (int)spacing);
            this.allowedNearSpawn = allowedNearSpawn;
        }
    }

    public static class Builder {
        private Vec3i locateOffset = Vec3i.f_123288_;
        private float probability = 1.0f;
        private Optional<TaggedExclusionZone> exclusionZone = Optional.empty();
        private int spacing = 16;
        private int offset = 16;
        private boolean allowedNearSpawn = false;
        private Supplier<StructureConfig> config = () -> null;

        private Builder() {
        }

        public Builder locateOffset(Vec3i locateOffset) {
            this.locateOffset = locateOffset;
            return this;
        }

        public Builder exclusionZone(TaggedExclusionZone exclusionZone) {
            this.exclusionZone = Optional.of(exclusionZone);
            return this;
        }

        public Builder spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder probability(float probability) {
            this.probability = probability;
            return this;
        }

        public Builder allowedNearSpawn(boolean allowedNearSpawn) {
            this.allowedNearSpawn = allowedNearSpawn;
            return this;
        }

        public Builder config(Supplier<StructureConfig> config) {
            this.config = config;
            return this;
        }

        public GridStructurePlacement build(ResourceLocation structureName) {
            return new GridStructurePlacement(structureName, this.locateOffset, this.exclusionZone, this.spacing, this.offset, this.probability, Math.abs(structureName.toString().hashCode()), this.allowedNearSpawn, this.config.get());
        }

        public GridStructurePlacement build(StructureRegistrar<?> structureRegistrar) {
            return this.build(structureRegistrar.getRegistryName());
        }
    }

    public record TaggedExclusionZone(HolderSet<Structure> structures, int radius) {
        private static final Codec<TaggedExclusionZone> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_235725_).fieldOf("structures").forGetter(TaggedExclusionZone::structures), (App)Codec.intRange((int)1, (int)16).fieldOf("radius").forGetter(TaggedExclusionZone::radius)).apply((Applicative)instance, TaggedExclusionZone::new));

        boolean isPlacementForbidden(ChunkGenerator chunkGenerator, RandomState randomState, long levelSeed, int chunkX, int chunkZ) {
            return StructureAccessHelper.hasStructureChunkInRange(chunkGenerator, randomState, this.structures, levelSeed, new ChunkPos(chunkX, chunkZ), this.radius);
        }
    }
}

