/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.screen.BuildingToolScreen;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.LeftClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.MiddleClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.UndoRedoPacket;
import com.legacy.structure_gel.core.network.UpdateBuildingToolPacket;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;

public final class BuildingToolItem
extends Item {
    private static final String MODE_KEY = "tool_mode";
    private static final String POSES_KEY = "poses";
    private static final String SELECTED_STATE_KEY = "selected_state";
    private static final String PROPERTIES_KEY = "properties";
    private static final String REACH_DISTANCE_MODIFIER_KEY = "reach_distance";
    private static final UUID REACH_UUID = UUID.fromString("d247f451-91f5-4819-8bc4-c3ad0baf94fe");
    private final BiFunction<BuildingToolMode, String, Component> nameCache = Util.m_143821_((mode, name) -> Component.m_237113_((String)name).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(mode.getComponent()));
    private static final Component NO_PERMISSION = Component.m_237115_((String)"info.structure_gel.building_tool.message.no_permission").m_130940_(ChatFormatting.RED);
    private static final String INFO_NAME = "item.structure_gel.building_tool.info.";
    private static final String OPEN_GUI_NAME = "item.structure_gel.building_tool.info.open_gui";
    private static final String SELECT_BLOCK_NAME = "item.structure_gel.building_tool.info.select_block";
    private static final String ZOOM_REACH_NAME = "item.structure_gel.building_tool.info.zoom_reach";
    private static final String SELECTED_STATE_NAME = "item.structure_gel.building_tool.info.selected_state";
    private static final String PROPERTY_KEY = "item.structure_gel.building_tool.info.property";

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(event -> {
            BlockPos blockPos;
            HitResult patt3508$temp = Minecraft.m_91087_().f_91077_;
            if (patt3508$temp instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)patt3508$temp;
                blockPos = blockHit.m_82425_();
            } else {
                blockPos = null;
            }
            this.onLeftClickEvent((PlayerInteractEvent)event, blockPos);
        });
        bus.addListener(event -> this.onLeftClickEvent((PlayerInteractEvent)event, event.getPos()));
        bus.addListener(event -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && event.getKeyMapping() == mc.f_91066_.f_92097_) {
                BlockHitResult blockHit;
                HitResult patt3997$temp = mc.f_91077_;
                this.onMiddleClickEvent((InputEvent.InteractionKeyMappingTriggered)event, (Player)mc.f_91074_, patt3997$temp instanceof BlockHitResult && (blockHit = (BlockHitResult)patt3997$temp).m_6662_() == HitResult.Type.BLOCK ? blockHit.m_82425_() : null);
            }
        });
        bus.addListener(event -> {
            if (event.getAction() == 1) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    ItemStack stack = ItemStack.f_41583_;
                    ItemStack off = mc.f_91074_.m_21206_();
                    if (off.m_150930_((Item)this)) {
                        stack = off;
                    } else {
                        ItemStack main = mc.f_91074_.m_21205_();
                        if (main.m_150930_((Item)this)) {
                            stack = main;
                        } else {
                            return;
                        }
                    }
                    InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(event.getKey());
                    if (((KeyMapping)ClientProxy.UNDO_KEY.get()).isActiveAndMatches(key) && this.hasPermission(stack, (Player)mc.f_91074_)) {
                        BuildingToolScreen.playClickSound();
                        PacketHandler.sendToServer(new UndoRedoPacket(true));
                    }
                    if (((KeyMapping)ClientProxy.REDO_KEY.get()).isActiveAndMatches(key) && this.hasPermission(stack, (Player)mc.f_91074_)) {
                        BuildingToolScreen.playClickSound();
                        PacketHandler.sendToServer(new UndoRedoPacket(false));
                    }
                }
            }
        });
        bus.addListener(event -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                int deltaReach;
                InteractionHand hand;
                ItemStack stack = ItemStack.f_41583_;
                ItemStack off = mc.f_91074_.m_21206_();
                if (off.m_150930_((Item)this)) {
                    hand = InteractionHand.OFF_HAND;
                    stack = off;
                } else {
                    ItemStack main = mc.f_91074_.m_21205_();
                    if (main.m_150930_((Item)this)) {
                        hand = InteractionHand.MAIN_HAND;
                        stack = main;
                    } else {
                        return;
                    }
                }
                if (mc.f_91066_.f_92091_.m_90857_() && this.hasPermission(stack, (Player)mc.f_91074_) && (deltaReach = (int)event.getScrollDelta()) != 0) {
                    int reach = BuildingToolItem.getReachDistanceModifier(stack) + deltaReach;
                    BuildingToolItem.setReachDistanceModifier(stack, reach);
                    PacketHandler.sendToServer(new UpdateBuildingToolPacket(hand, Optional.empty(), Map.of(), Optional.empty(), Optional.empty(), Optional.of(reach)));
                    event.setCanceled(true);
                }
            }
        });
    }

    public BuildingToolItem(Item.Properties properties) {
        super(properties);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientInit());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            return ImmutableMultimap.of((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(REACH_UUID, "building_tool_reach", (double)(BuildingToolItem.getReachDistanceModifier(stack) + BuildingToolItem.getMode(stack).getReachDistance(stack)), AttributeModifier.Operation.ADDITION));
        }
        return ImmutableMultimap.of();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && this.hasPermission(stack, player)) {
            BuildingToolItem.getMode(stack).useOn(context);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasPermission(stack, player)) {
            if (player.m_6144_()) {
                BuildingToolItem.getMode(stack).onShiftRightClickAir(level, player, stack);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (level.f_46443_) {
                StructureGelMod.proxy.openBuildingToolScreen(stack, hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onLeftClick(ItemStack stack, Player player, BlockPos clickedPos, Direction clickedFace) {
        if (this.hasPermission(stack, player) && (!player.f_20911_ || player.f_20913_ > 1)) {
            BuildingToolItem.getMode(stack).onLeftClick(player.f_19853_, player, clickedPos, stack, clickedFace);
        }
    }

    private void onLeftClickEvent(PlayerInteractEvent event, @Nullable BlockPos pos) {
        if (pos != null) {
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player != null && player.f_19853_.f_46443_ && this.hasPermission(stack, player)) {
                Direction clickedFace = event.getFace();
                if (clickedFace == null) {
                    clickedFace = Direction.UP;
                }
                this.onLeftClick(stack, player, pos, clickedFace);
                PacketHandler.sendToServer(new LeftClickBuildingToolPacket(event.getHand(), pos, clickedFace));
            }
        }
    }

    public void onMiddleClick(ItemStack stack, Player player, @Nullable BlockPos clickedPos) {
        if (this.hasPermission(stack, player) && clickedPos != null) {
            BuildingToolItem.getMode(stack).onMiddleClick(player.f_19853_, player, clickedPos, stack);
        }
    }

    private void onMiddleClickEvent(InputEvent.InteractionKeyMappingTriggered event, Player player, @Nullable BlockPos pos) {
        InteractionHand hand;
        ItemStack stack;
        if (player != null && pos != null && this.hasPermission(stack = player.m_21120_(hand = event.getHand()), player)) {
            this.onMiddleClick(stack, player, pos);
            player.m_6674_(hand);
            PacketHandler.sendToServer(new MiddleClickBuildingToolPacket(hand, pos));
            event.setCanceled(true);
        }
    }

    public Component m_7626_(ItemStack stack) {
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        Component name = super.m_7626_(stack);
        if (mode == BuildingToolMode.NONE) {
            return name;
        }
        return this.nameCache.apply(mode, name.getString());
    }

    private boolean hasPermission(ItemStack stack, Player player) {
        if (stack.m_150930_((Item)this)) {
            boolean ret;
            boolean bl = ret = player.m_7500_() && player.m_20310_(SGConfig.COMMON.getBuildingToolRequiredPermission());
            if (!ret) {
                player.m_5661_(NO_PERMISSION, true);
            }
            return ret;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag showAdvanced) {
        if (!Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"info.structure_gel.hold_shift").m_130940_(ChatFormatting.GRAY));
        } else {
            String rightClick = Minecraft.m_91087_().f_91066_.f_92095_.getKey().m_84875_().getString();
            String control = Minecraft.m_91087_().f_91066_.f_92091_.getKey().m_84875_().getString();
            list.add((Component)Component.m_237110_((String)OPEN_GUI_NAME, (Object[])new Object[]{rightClick}).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237110_((String)SELECT_BLOCK_NAME, (Object[])new Object[]{rightClick}).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237110_((String)ZOOM_REACH_NAME, (Object[])new Object[]{control}).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237113_((String)" "));
            Optional<BlockState> state = BuildingToolItem.getSelectedState(stack);
            if (state.isPresent()) {
                list.add((Component)Component.m_237110_((String)SELECTED_STATE_NAME, (Object[])new Object[]{state.get().m_60734_().m_49954_()}).m_130940_(ChatFormatting.GRAY));
            }
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            for (ToolModeProperty<?> property : mode.getProperties().values()) {
                list.add((Component)Component.m_237110_((String)PROPERTY_KEY, (Object[])new Object[]{property.getNameComponent().getString(), property.getValueComponent(BuildingToolItem.getProperty(stack, property)).getString()}).m_130940_(ChatFormatting.GRAY));
            }
            list.add((Component)Component.m_237113_((String)" "));
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!other.m_41619_() && clickAction == ClickAction.SECONDARY) {
            BlockState state;
            Item item = other.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                state = blockItem.m_40614_().m_49966_();
            } else {
                item = other.m_41720_();
                if (item instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)item;
                    state = bucket.getFluid().m_76145_().m_76188_();
                } else {
                    item = other.m_41720_();
                    if (item instanceof SolidBucketItem) {
                        SolidBucketItem solidBucket = (SolidBucketItem)item;
                        state = solidBucket.m_40614_().m_49966_();
                    } else {
                        state = Blocks.f_50626_.m_49966_();
                    }
                }
            }
            if (state.m_60713_(Blocks.f_50016_)) {
                state = Blocks.f_50626_.m_49966_();
            }
            BuildingToolItem.setSelectedState(stack, state);
            player.m_5496_(SoundEvents.f_12019_, 0.8f, 0.9f + player.m_9236_().m_213780_().m_188501_() * 0.2f);
            return true;
        }
        return false;
    }

    public static BuildingToolMode getMode(ItemStack stack) {
        BuildingToolMode mode;
        String modeS;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MODE_KEY, 8) && ResourceLocation.m_135830_((String)(modeS = tag.m_128461_(MODE_KEY))) && (mode = BuildingToolMode.REGISTRY.get(new ResourceLocation(modeS))) != null) {
            return mode;
        }
        return BuildingToolMode.NONE;
    }

    public static void setMode(ItemStack stack, BuildingToolMode mode) {
        stack.m_41784_().m_128359_(MODE_KEY, mode.getName().toString());
        stack.m_41784_().m_128473_(PROPERTIES_KEY);
    }

    public static Optional<BlockPos> getPos(ItemStack stack, int index) {
        int[] coords;
        String indexKey;
        CompoundTag poses;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POSES_KEY, 10) && (poses = tag.m_128469_(POSES_KEY)).m_128425_(indexKey = Integer.toString(index), 11) && (coords = poses.m_128465_(indexKey)).length == 3) {
            return Optional.of(new BlockPos(coords[0], coords[1], coords[2]));
        }
        return Optional.empty();
    }

    public static void setPos(ItemStack stack, int index, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag posesTag = tag.m_128469_(POSES_KEY);
        posesTag.m_128385_(Integer.toString(index), new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        tag.m_128365_(POSES_KEY, (Tag)posesTag);
    }

    public static void clearPoses(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POSES_KEY, 10)) {
            tag.m_128365_(POSES_KEY, (Tag)new CompoundTag());
        }
    }

    public static Optional<BlockState> getSelectedState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(SELECTED_STATE_KEY, 10)) {
            CompoundTag stateTag = tag.m_128469_(SELECTED_STATE_KEY);
            try {
                BlockState state = NbtUtils.m_129241_((CompoundTag)stateTag);
                if (!state.m_60713_(Blocks.f_50016_)) {
                    return Optional.of(state.m_60713_(Blocks.f_50626_) ? Blocks.f_50016_.m_49966_() : state);
                }
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error("Couldn't read block state from tag.", stateTag.m_7916_());
            }
        }
        return Optional.empty();
    }

    public static void setSelectedState(ItemStack stack, BlockState state) {
        stack.m_41784_().m_128365_(SELECTED_STATE_KEY, (Tag)NbtUtils.m_129202_((BlockState)state));
    }

    public static void clearSelectedState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(SELECTED_STATE_KEY, 10)) {
            tag.m_128473_(SELECTED_STATE_KEY);
        }
    }

    public static <T> T getProperty(ItemStack stack, ToolModeProperty<T> property) {
        String key;
        CompoundTag propertiesTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(PROPERTIES_KEY, 10) && (propertiesTag = tag.m_128469_(PROPERTIES_KEY)).m_128425_(key = property.getKey(), 8)) {
            return property.read(propertiesTag.m_128461_(key));
        }
        return property.getDefaultValue();
    }

    public static <T> void setProperty(ItemStack stack, ToolModeProperty<T> property, T value) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag propertiesTag = tag.m_128469_(PROPERTIES_KEY);
        propertiesTag.m_128359_(property.getKey(), property.write(value));
        tag.m_128365_(PROPERTIES_KEY, (Tag)propertiesTag);
    }

    public static int getReachDistanceModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(REACH_DISTANCE_MODIFIER_KEY, 3)) {
            return tag.m_128451_(REACH_DISTANCE_MODIFIER_KEY);
        }
        return 0;
    }

    public static void setReachDistanceModifier(ItemStack stack, int reachDistanceModifier) {
        reachDistanceModifier = Mth.m_14045_((int)reachDistanceModifier, (int)ToolModeProperty.REACH_DISTANCE.min(), (int)ToolModeProperty.REACH_DISTANCE.max());
        stack.m_41784_().m_128405_(REACH_DISTANCE_MODIFIER_KEY, reachDistanceModifier);
    }
}

