/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.codexadrian.tempad.Constants;
import me.codexadrian.tempad.data.tempad_options.DurabilityOption;
import me.codexadrian.tempad.data.tempad_options.EnergyOption;
import me.codexadrian.tempad.data.tempad_options.ExperienceLevelOption;
import me.codexadrian.tempad.data.tempad_options.ExperiencePointsOption;
import me.codexadrian.tempad.data.tempad_options.ItemOption;
import me.codexadrian.tempad.data.tempad_options.TempadOption;
import me.codexadrian.tempad.data.tempad_options.TimerOption;
import me.codexadrian.tempad.data.tempad_options.UnlimitedOption;

public class TempadConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="timedoorPlacementOffsetInBlocks")
    private int distanceFromPlayer = 3;
    @SerializedName(value="timedoorCloseWaitingTimeInTicks")
    private int timedoorWait = 60;
    @SerializedName(value="onEntityThroughDoorAdditionalTimeInTicks")
    private int timedoorAddWaitTime = 40;
    @SerializedName(value="timedoorUsageType")
    private String tempadOption = "TIMER";
    @SerializedName(value="kangTimedoorUsageType")
    private String heWhoRemainsTempadOption = "UNLIMITED";
    @SerializedName(value="configurationOptionsForTempad")
    private TempadOptionConfig tempadOptions = new TempadOptionConfig(180, 100, 5, 1000000, 100000);
    @SerializedName(value="configurationOptionsForHeWhoRemainsTempad")
    private TempadOptionConfig heWhoRemainsOptions = new TempadOptionConfig(60, 60, 3, 5000000, 25000);

    public static TempadConfig loadConfig(Path configFolder) throws IOException {
        Path configPath = configFolder.resolve("tempad.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            TempadConfig config = new TempadConfig();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            Constants.LOG.info("Created config file for mod tempad");
            return config;
        }
        return (TempadConfig)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(configPath, new OpenOption[0])), TempadConfig.class);
    }

    public int getDistanceFromPlayer() {
        return this.distanceFromPlayer;
    }

    public int getTimedoorAddWaitTime() {
        return this.timedoorAddWaitTime;
    }

    public int getTimedoorWait() {
        return this.timedoorWait;
    }

    public TempadOption getTempadOption() {
        return switch (this.tempadOption) {
            case "DURABILITY" -> DurabilityOption.NORMAL_INSTANCE;
            case "ENERGY" -> EnergyOption.NORMAL_INSTANCE;
            case "ITEM" -> ItemOption.NORMAL_INSTANCE;
            case "UNLIMITED" -> UnlimitedOption.NORMAL_INSTANCE;
            case "EXP_POINTS" -> ExperiencePointsOption.NORMAL_INSTANCE;
            case "EXP_LEVELS" -> ExperienceLevelOption.NORMAL_INSTANCE;
            default -> TimerOption.NORMAL_INSTANCE;
        };
    }

    public TempadOption getHeWhoRemainsOption() {
        return switch (this.heWhoRemainsTempadOption) {
            case "DURABILITY" -> DurabilityOption.ADVANCED_INSTANCE;
            case "ENERGY" -> EnergyOption.ADVANCED_INSTANCE;
            case "ITEM" -> ItemOption.ADVANCED_INSTANCE;
            case "TIMER" -> TimerOption.ADVANCED_INSTANCE;
            case "EXP_POINTS" -> ExperiencePointsOption.ADVANCED_INSTANCE;
            case "EXP_LEVELS" -> ExperienceLevelOption.ADVANCED_INSTANCE;
            default -> UnlimitedOption.ADVANCED_INSTANCE;
        };
    }

    public TempadOptionConfig getTempadOptions() {
        return this.tempadOptions;
    }

    public TempadOptionConfig getHeWhoRemainsOptions() {
        return this.heWhoRemainsOptions;
    }

    public static class TempadOptionConfig {
        @SerializedName(value="timedoor_cooldown_if_usage_type_is_set_to_TIMER")
        private int cooldownTime;
        @SerializedName(value="timedoor_experience_cost_if_usage_type_is_set_to_EXP_POINTS")
        private int expCost;
        @SerializedName(value="timedoor_experience_level_cost_if_usage_type_is_set_to_EXP_LEVELS")
        private int expLevelCost;
        @SerializedName(value="timedoor_energy_capacity_if_usage_type_is_set_to_ENERGY")
        private int energyCapacity;
        @SerializedName(value="timedoor_energy_cost_if_usage_type_is_set_to_ENERGY")
        private int energyCost;

        public TempadOptionConfig(int cooldownTime, int tempadExperienceCost, int tempadExperienceLevelCost, int tempadEnergyCapacity, int tempadEnergyCost) {
            this.cooldownTime = cooldownTime;
            this.expCost = tempadExperienceCost;
            this.expLevelCost = tempadExperienceLevelCost;
            this.energyCapacity = tempadEnergyCapacity;
            this.energyCost = tempadEnergyCost;
        }

        public int getCooldownTime() {
            return this.cooldownTime;
        }

        public int getExperienceCost() {
            return this.expCost;
        }

        public int getExperienceLevelCost() {
            return this.expLevelCost;
        }

        public int getEnergyCapacity() {
            return this.energyCapacity;
        }

        public int getEnergyCost() {
            return this.energyCost;
        }
    }
}

