/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TesseractReference {
    private final long index;
    private final String dimension;
    private final BlockPos pos;
    private final boolean isClientSide;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);
    private WeakReference<TesseractBlockEntity> entity;

    TesseractReference(long index, TesseractBlockEntity entity) {
        this.index = index;
        this.dimension = entity.m_58904_().m_46472_().m_135782_().toString();
        this.pos = entity.m_58899_();
        this.isClientSide = entity.m_58904_().f_46443_;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, -1);
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
        }
    }

    public TesseractReference(long index, CompoundTag tag, boolean isClientSide) {
        this.index = index;
        this.dimension = tag.m_128461_("dim");
        this.pos = new BlockPos(tag.m_128451_("posx"), tag.m_128451_("posy"), tag.m_128451_("posz"));
        this.isClientSide = isClientSide;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.m_128451_(type + "_channel"));
            this.canSend.put(type, tag.m_128471_(type + "_canSend"));
            this.canReceive.put(type, tag.m_128471_(type + "_canReceive"));
        }
    }

    public long getSaveIndex() {
        return this.index;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Level getLevel() {
        if (this.isClientSide) {
            return ClientUtils.getWorld().m_46472_().m_135782_().toString().equals(this.dimension) ? ClientUtils.getWorld() : null;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.dimension));
        return CommonUtils.getLevel((ResourceKey)key);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        Level level = this.getLevel();
        boolean bl = isValid = level != null && level.m_8055_(this.pos).m_60734_() == Tesseract.tesseract && level.m_7702_(this.pos) instanceof TesseractBlockEntity;
        if (!isValid && !this.isClientSide) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public boolean canBeAccessed() {
        Level level = this.getLevel();
        return level != null && this.getLevel().m_46749_(this.pos) && this.isValid();
    }

    public TesseractBlockEntity getTesseract() {
        if (this.entity == null || this.entity.get() == null || ((TesseractBlockEntity)((Object)this.entity.get())).m_58901_() || !((TesseractBlockEntity)((Object)this.entity.get())).m_58899_().equals((Object)this.pos)) {
            this.entity = new WeakReference<TesseractBlockEntity>((TesseractBlockEntity)this.getLevel().m_7702_(this.pos));
        }
        return this.entity == null ? null : (TesseractBlockEntity)((Object)this.entity.get());
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("dim", this.dimension);
        compound.m_128405_("posx", this.pos.m_123341_());
        compound.m_128405_("posy", this.pos.m_123342_());
        compound.m_128405_("posz", this.pos.m_123343_());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.m_128405_(type + "_channel", this.channels.get((Object)type).intValue());
            compound.m_128379_(type + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.m_128379_(type + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.isClientSide).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.isClientSide) {
            this.channels.put(type, -1);
            this.markDirty();
            if (this.canBeAccessed()) {
                this.getTesseract().channelChanged(type);
            }
        }
        return channel;
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this);
        }
        this.markDirty();
        if (this.canBeAccessed()) {
            this.getTesseract().channelChanged(type);
        }
    }

    public void update(TesseractBlockEntity entity) {
        for (EnumChannelType type : EnumChannelType.values()) {
            boolean canReceive;
            boolean changed = false;
            boolean canSend = entity.canSend(type);
            if (canSend != this.canSend.put(type, canSend)) {
                changed = true;
            }
            if ((canReceive = entity.canReceive(type)) != this.canReceive.put(type, canReceive)) {
                changed = true;
            }
            if (!changed) continue;
            Channel channel = this.getChannel(type);
            if (channel != null) {
                channel.updateTesseract(this);
            }
            this.markDirty();
        }
    }

    private void markDirty() {
        if (!this.isClientSide) {
            TesseractTracker.SERVER.markDirty(this);
        }
    }

    void delete() {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel = this.getChannel(type);
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

