/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class PacketCompleteChannelsUpdate
implements BasePacket {
    private List<Channel> channels;

    public PacketCompleteChannelsUpdate(boolean server) {
        if (!server) {
            throw new IllegalStateException();
        }
        List[] lists = new List[EnumChannelType.values().length];
        int index = 0;
        int size = 0;
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            lists[index] = TesseractChannelManager.SERVER.getChannels(enumChannelType);
            size += lists[index].size();
            ++index;
        }
        this.channels = new ArrayList<Channel>(size);
        for (List list : lists) {
            this.channels.addAll(list);
        }
    }

    public PacketCompleteChannelsUpdate() {
    }

    public void write(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        Iterator<Channel> iterator = this.channels.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            compound.m_128365_(Integer.toString(index), (Tag)iterator.next().writeClientChannel());
            ++index;
        }
        buffer.m_130079_(compound);
    }

    public void read(FriendlyByteBuf buffer) {
        CompoundTag compound = buffer.m_130260_();
        this.channels = new ArrayList<Channel>();
        for (String key : compound.m_128431_()) {
            this.channels.add(Channel.readClientChannel(compound.m_128469_(key)));
        }
    }

    public void handle(PacketContext buffer) {
        TesseractChannelManager.CLIENT.clear();
        HashSet types = new HashSet(3);
        this.channels.forEach(channel -> {
            TesseractChannelManager.CLIENT.addChannel((Channel)channel);
            types.add(channel.type);
        });
        types.forEach(type -> TesseractChannelManager.CLIENT.sortChannels(ClientUtils.getPlayer(), (EnumChannelType)((Object)type)));
    }
}

