/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid;

import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.grid.Grid;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class GridNode<G extends Grid<G, ?>>
implements INBTSerializable<CompoundTag> {
    protected final EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
    protected G grid;
    protected BlockPos pos = BlockPos.f_121853_;
    protected boolean loaded;
    protected boolean cached;

    protected GridNode(G grid) {
        this.grid = grid;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    public void onGridChange(G oldGrid) {
    }

    public final void clearConnections() {
        this.connections.clear();
        this.cached = false;
    }

    public final G getGrid() {
        return this.grid;
    }

    public final BlockPos getPos() {
        return this.pos;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public final EnumSet<Direction> getConnections() {
        return this.connections;
    }

    @Nullable
    protected IDuct<?, ?> gridHost() {
        return GridHelper.getGridHost((BlockGetter)this.getWorld(), this.getPos());
    }

    public final Level getWorld() {
        return ((Grid)this.grid).getLevel();
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setGrid(G grid) {
        this.grid = grid;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

