/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import cofh.thermal.dynamics.ThermalDynamics;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IPacketHandlerAttachment;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AttachmentControlPacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected Direction side;
    protected FriendlyByteBuf buffer;

    public AttachmentControlPacket() {
        super(1, ThermalDynamics.PACKET_HANDLER);
    }

    public void handleClient() {
        IDuct duct;
        IAttachment iAttachment;
        Level world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IDuct && (iAttachment = (duct = (IDuct)tile).getAttachment(this.side)) instanceof IPacketHandlerAttachment) {
            IPacketHandlerAttachment attachment = (IPacketHandlerAttachment)iAttachment;
            attachment.handleControlPacket(this.buffer);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.side);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
        this.side = (Direction)this.buffer.m_130066_(Direction.class);
    }

    public static void sendToClient(IPacketHandlerAttachment attachment) {
        if (attachment.world() == null || Utils.isClientWorld((Level)attachment.world()) || !attachment.hasControlPacket()) {
            return;
        }
        AttachmentControlPacket packet = new AttachmentControlPacket();
        packet.pos = attachment.pos();
        packet.side = attachment.side();
        packet.buffer = attachment.getControlPacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToAllAround(packet.pos, 192.0, attachment.world().m_46472_());
    }
}

