/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.locomotion.client.renderer.entity.UnderwaterMinecartRenderer;
import cofh.thermal.locomotion.client.renderer.entity.model.UnderwaterMinecartModel;
import cofh.thermal.locomotion.init.TLocBlocks;
import cofh.thermal.locomotion.init.TLocEntities;
import cofh.thermal.locomotion.init.TLocItems;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="thermal_locomotion")
public class ThermalLocomotion {
    public ThermalLocomotion() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        TLocBlocks.register();
        TLocItems.register();
        TLocEntities.register();
    }

    private void setFeatureFlags() {
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UnderwaterMinecartModel.UNDERWATER_MINECART_LAYER, UnderwaterMinecartModel::createMesh);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TLocEntities.UNDERWATER_CART.get(), UnderwaterMinecartRenderer::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerRenderLayers);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_activator_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_detector_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("prismarine_powered_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_crossover_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_activator_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_detector_rail")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("lumium_powered_rail")), (RenderType)cutout);
    }
}

