/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.commands;

import com.haoict.tiab.config.TiabConfig;
import com.haoict.tiab.items.TimeInABottleItem;
import com.haoict.tiab.utils.SendMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TiabCommands {
    private static final String ADD_TIME_COMMAND = "addTime";
    private static final String REMOVE_TIME_COMMAND = "removeTime";
    private static final String TIME_PARAM = "seconds";
    public static LiteralArgumentBuilder<CommandSourceStack> addTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addTime").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"seconds", (ArgumentType)MessageArgument.m_96832_()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));
    public static LiteralArgumentBuilder<CommandSourceStack> removeTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeTime").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"seconds", (ArgumentType)MessageArgument.m_96832_()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<CommandSourceStack>)ctx, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));

    private static int processTimeCommand(CommandContext<CommandSourceStack> ctx, boolean isAdd) throws CommandSyntaxException {
        Component messageValue = MessageArgument.m_96835_(ctx, (String)TIME_PARAM);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        if (!messageValue.getString().isEmpty()) {
            try {
                int timeToAdd = Integer.parseInt(messageValue.getString());
                if (timeToAdd < 0) {
                    throw new NumberFormatException();
                }
                if (timeToAdd > (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20) {
                    timeToAdd = (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20;
                }
                boolean success = false;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack invStack = player.m_150109_().m_8020_(i);
                    Item item = invStack.m_41720_();
                    if (!(item instanceof TimeInABottleItem)) continue;
                    TimeInABottleItem itemTiab = (TimeInABottleItem)item;
                    int currentStoredEnergy = itemTiab.getStoredEnergy(invStack);
                    if (!isAdd) {
                        if (currentStoredEnergy / 20 < timeToAdd) {
                            timeToAdd = currentStoredEnergy / 20;
                        }
                        timeToAdd = -timeToAdd;
                    }
                    itemTiab.setStoredEnergy(invStack, currentStoredEnergy + timeToAdd * 20);
                    SendMessage.sendStatusMessage(player, String.format("%s %d seconds", isAdd ? "Added" : "Removed ", timeToAdd));
                    success = true;
                }
                if (!success) {
                    SendMessage.sendStatusMessage(player, "No Time in a bottle item in inventory");
                }
                return 1;
            }
            catch (NumberFormatException ex) {
                SendMessage.sendStatusMessage(player, "Invalid time parameter! (is the number too big?)");
            }
        } else {
            SendMessage.sendStatusMessage(player, "Empty time parameter!");
        }
        return 0;
    }
}

