/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageUpgradePerk(SyncType syncType, Perk perk) {
    static SMessageUpgradePerk fromBytes(FriendlyByteBuf buf) {
        return new SMessageUpgradePerk(buf.readBoolean() ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, (Perk)PerkRegistry.get().getValue((int)buf.readShort()));
    }

    static void toBytes(SMessageUpgradePerk msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.syncType == SyncType.DOWNGRADE_PERK);
        buf.writeShort(PerkRegistry.get().getID((Object)msg.perk));
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }

    public static class Handler {
        static void handle(final SMessageUpgradePerk message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayer player = ctx.getSender();
                        if (player != null && !message.perk.isDisabled((Player)player)) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                                int levelPerk = cap.getPerkLevel((Player)player, message2.perk);
                                int totalPerkPoints = cap.getTotalPerkPoints();
                                if (message2.syncType == SyncType.UPGRADE_PERK && levelPerk < Math.min(message2.perk.getLevelMax(), EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints)) && totalPerkPoints - cap.getUsedPerkPoints((Player)player) >= message2.perk.getCost(levelPerk + 1)) {
                                    cap.setPerk(message2.perk, levelPerk + 1);
                                    ModTriggers.SELECTED_PERKS.trigger(player);
                                    PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.SET_PERK, message2.perk, levelPerk + 1), player);
                                } else if (message2.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0 && player.m_7500_()) {
                                    cap.setPerk(message2.perk, levelPerk - 1);
                                    PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.SET_PERK, message2.perk, levelPerk - 1), player);
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

