/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.vitalize.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import earth.terrarium.vitalize.blocks.SoulRevitalizerMenu;
import earth.terrarium.vitalize.client.widgets.NonSelectableTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.entity.EntityRarity;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulTranslatorScreen
extends AbstractContainerScreen<SoulRevitalizerMenu> {
    private static final ResourceLocation BASE_SCREEN = new ResourceLocation("vitalize", "textures/gui/soul_revitalizer_gui.png");
    public Optional<Entity> entity = Optional.empty();
    private Tier tier;
    private SelectionList boxComponents;
    @Nullable
    private ItemStack crystal;

    public SoulTranslatorScreen(SoulRevitalizerMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.f_97726_ = 208;
        this.f_97727_ = 202;
        this.f_97730_ = 23;
        this.f_97731_ = 106;
        abstractContainerMenu.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu abstractContainerMenu, int i, @NotNull ItemStack itemStack) {
            }

            public void m_142153_(@NotNull AbstractContainerMenu abstractContainerMenu, int i, int j) {
                SoulTranslatorScreen.this.entity = Optional.empty();
                SoulTranslatorScreen.this.tier = null;
            }
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        this.boxComponents = (SelectionList)this.m_142416_((GuiEventListener)new SelectionList(this.f_97735_ + 86, this.f_97736_ + 20, 77, 80, 10, entry -> {}));
        this.boxComponents.updateEntries(this.baseComponents());
    }

    protected void m_181908_() {
        ItemStack item = (ItemStack)((SoulRevitalizerMenu)this.m_6262_()).m_38927_().get(0);
        if (this.crystal != item) {
            if (item.m_41619_()) {
                this.crystal = ItemStack.f_41583_;
                this.entity = Optional.empty();
                this.boxComponents.updateEntries(this.baseComponents());
            } else {
                this.crystal = item;
                List entries = this.getComponentsFromTier(this.getOrCreateTier()).stream().map(NonSelectableTextComponent::new).collect(Collectors.toList());
                List<NonSelectableTextComponent> components = this.baseComponents();
                if (!components.isEmpty()) {
                    entries.add(new NonSelectableTextComponent((Component)Component.m_237113_((String)"---------------").m_130940_(ChatFormatting.STRIKETHROUGH).m_130940_(ChatFormatting.GRAY)));
                }
                entries.addAll(components);
                this.boxComponents.updateEntries(entries);
                this.getOrCreateEntity();
            }
        }
    }

    protected void m_7286_(@NotNull PoseStack matrixStack, float f, int i, int j) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE_SCREEN);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int energyBarHeight = Mth.m_14045_((int)((int)(58.0f * ((float)this.getEnergyLevel() / (float)this.getMaxEnergyLevel()))), (int)0, (int)58);
        this.m_93228_(matrixStack, this.f_97735_ + 186, this.f_97736_ + 19 + (58 - energyBarHeight), 208, 58 - energyBarHeight, 12, energyBarHeight);
        int tickBarHeight = Mth.m_14045_((int)((int)(58.0f * ((float)this.getTicks() / (float)this.getMaxTicks()))), (int)0, (int)58);
        this.m_93228_(matrixStack, this.f_97735_ + 172, this.f_97736_ + 19 + (58 - tickBarHeight), 220, 0, 6, tickBarHeight);
        this.getOrCreateEntity().ifPresent(entity -> {
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)this.f_96541_, (PoseStack)matrixStack, (int)(this.f_97735_ + 7), (int)(this.f_97736_ + 17), (int)73, (int)84);){
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    float renderScale = 2.0f;
                    float scaledSize = 20.0f / Math.max(entity.m_20205_(), entity.m_20206_());
                    entity.f_19797_ = mc.f_91074_.f_19797_;
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(34.0, (double)(20.0f * renderScale + 25.0f), 0.5);
                    matrixStack.m_85837_((double)(this.f_97735_ + 7), (double)(this.f_97736_ + 17), 1.0);
                    matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                    matrixStack.m_85837_(0.0, 0.0, 100.0);
                    matrixStack.m_85841_(-scaledSize * renderScale, scaledSize * renderScale, 30.0f);
                    matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
                    EntityRenderDispatcher manager = mc.m_91290_();
                    MultiBufferSource.BufferSource renderTypeBuffer = mc.m_91269_().m_110104_();
                    manager.m_114384_(entity, 0.0, 0.0, 0.0, mc.m_91296_(), 1.0f, matrixStack, (MultiBufferSource)renderTypeBuffer, 0xF000F0);
                    renderTypeBuffer.m_109911_();
                    matrixStack.m_85849_();
                }
            }
        });
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (mouseX > this.f_97735_ + 183 && mouseX < 200 + this.f_97735_ && mouseY > 17 + this.f_97736_ && mouseY < 79 + this.f_97736_) {
            this.m_96602_(poseStack, (Component)Component.m_237110_((String)"gui.vitalize.energy_tooltip", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.getEnergyLevel())).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)String.valueOf(this.getMaxEnergyLevel())).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.AQUA), mouseX, mouseY);
        } else if (mouseX > this.f_97735_ + 169 && mouseX < 180 + this.f_97735_ && mouseY > 17 + this.f_97736_ && mouseY < 79 + this.f_97736_) {
            this.m_96602_(poseStack, (Component)Component.m_237110_((String)"gui.vitalize.work_tooltip", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.getTicks())).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)String.valueOf(this.getMaxTicks())).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.AQUA), mouseX, mouseY);
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int i, int j) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x333333);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x333333);
    }

    public int getEnergyLevel() {
        return ((SoulRevitalizerMenu)this.m_6262_()).data.m_6413_(2);
    }

    public int getMaxEnergyLevel() {
        return ((SoulRevitalizerMenu)this.m_6262_()).data.m_6413_(3);
    }

    public int getTicks() {
        return ((SoulRevitalizerMenu)this.m_6262_()).data.m_6413_(0);
    }

    public int getMaxTicks() {
        return ((SoulRevitalizerMenu)this.m_6262_()).data.m_6413_(1);
    }

    public int getEnergyConsumption() {
        return ((SoulRevitalizerMenu)this.m_6262_()).data.m_6413_(4);
    }

    public Optional<Entity> getOrCreateEntity() {
        String entityName;
        if (this.entity.isEmpty() && this.crystal != null && this.crystal.m_150930_((Item)SpiritItems.SOUL_CRYSTAL.get()) && (entityName = SoulUtils.getSoulCrystalType((ItemStack)this.crystal)) != null) {
            this.entity = EntityType.m_20632_((String)entityName).map(entityType -> entityType.m_20615_((Level)this.f_96541_.f_91073_));
            return this.entity;
        }
        return this.entity;
    }

    @Nullable
    public Tier getOrCreateTier() {
        if (this.tier == null && this.crystal != null && this.crystal.m_150930_((Item)SpiritItems.SOUL_CRYSTAL.get())) {
            this.tier = SoulUtils.getTier((ItemStack)this.crystal, (Level)this.f_96541_.f_91073_);
            return this.tier;
        }
        return this.tier;
    }

    private List<Supplier<Component>> getComponentsFromTier(Tier tier) {
        ArrayList<Supplier<Component>> components = new ArrayList<Supplier<Component>>();
        if (tier != null) {
            this.getOrCreateEntity().ifPresent(entity -> components.add(() -> Component.m_237110_((String)"gui.vitalize.summoning", (Object[])new Object[]{entity.m_6095_().m_20676_(), tier.displayName()})));
            this.getOrCreateEntity().ifPresent(entity -> {
                EntityRarity rarity = EntityRarity.getRarity((EntityType)entity.m_6095_());
                components.add(() -> Component.m_237110_((String)"gui.vitalize.rarity", (Object[])new Object[]{rarity.getTranslation().m_6881_().m_130940_(ChatFormatting.AQUA)}).m_130940_(rarity.color));
            });
            this.getOrCreateEntity().ifPresent(entity -> components.add(() -> Component.m_237110_((String)"gui.vitalize.tier", (Object[])new Object[]{Component.m_237115_((String)tier.displayName())})));
            components.add(() -> Component.m_237110_((String)"gui.vitalize.consuming", (Object[])new Object[]{this.getEnergyConsumption()}));
            components.add(() -> Component.m_237110_((String)"gui.vitalize.work_time", (Object[])new Object[]{this.getMaxTicks() / 20}));
            components.add(() -> Component.m_237110_((String)"gui.vitalize.spawn_count", (Object[])new Object[]{tier.spawnCount()}));
        }
        return components;
    }

    private List<NonSelectableTextComponent> baseComponents() {
        ArrayList<NonSelectableTextComponent> components = new ArrayList<NonSelectableTextComponent>();
        if (((SoulRevitalizerMenu)this.m_6262_()).missingPylons) {
            components.add(new NonSelectableTextComponent((Component)Component.m_237115_((String)"gui.vitalize.missing_pylons").m_130940_(ChatFormatting.RED)));
        }
        if (((SoulRevitalizerMenu)this.m_6262_()).missingInventory) {
            components.add(new NonSelectableTextComponent((Component)Component.m_237115_((String)"gui.vitalize.missing_inventory").m_130940_(ChatFormatting.RED)));
        }
        return components;
    }
}

