/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.ChemicalLogicEnums;
import terrails.xnetgases.module.logic.ChemicalSensor;

public class ChemicalLogicConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_REDSTONE_OUT = "rsout";
    public static final String TAG_SENSORS = "sensors";
    public static final String TAG_COLORS = "colors";
    private static final Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});
    public static final int SENSORS = 4;
    private ChemicalLogicEnums.ConnectorMode connectorMode = ChemicalLogicEnums.ConnectorMode.SENSOR;
    private final List<ChemicalSensor> sensors = new ArrayList<ChemicalSensor>(4);
    private int colors;
    private int speed = 2;
    private Integer redstoneOut;

    public ChemicalLogicConnectorSettings(@Nonnull Direction side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new ChemicalSensor(i));
        }
    }

    public List<ChemicalSensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    public Integer getRedstoneOut() {
        return this.redstoneOut;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.connectorMode != ChemicalLogicEnums.ConnectorMode.OUTPUT;
        }
        if (tag.equals("operation_speed")) {
            return true;
        }
        for (ChemicalSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public int getSpeed() {
        return this.speed;
    }

    public ChemicalLogicEnums.ConnectorMode getConnectorMode() {
        return this.connectorMode;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices("mode", "Sensor or Output mode", (Enum)this.connectorMode, (Enum[])ChemicalLogicEnums.ConnectorMode.values()).choices("operation_speed", this.connectorMode == ChemicalLogicEnums.ConnectorMode.SENSOR ? "Number of ticks for each check" : "Number of ticks for each operation", Integer.toString(this.speed * 5), speeds).nl();
        switch (this.connectorMode) {
            case SENSOR: {
                for (ChemicalSensor sensor : this.sensors) {
                    sensor.createGui(gui);
                }
                break;
            }
            case OUTPUT: {
                gui.label("Redstone:").integer(TAG_REDSTONE_OUT, "Redstone output value", this.redstoneOut, 40, Integer.valueOf(16)).nl();
            }
        }
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.connectorMode = ChemicalLogicEnums.ConnectorMode.valueOf(((String)data.get("mode")).toUpperCase());
        this.speed = Integer.parseInt((String)data.get("operation_speed")) / 5;
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (this.connectorMode == ChemicalLogicEnums.ConnectorMode.SENSOR) {
            for (ChemicalSensor sensor : this.sensors) {
                sensor.update(data);
            }
        } else {
            this.redstoneOut = (Integer)data.get(TAG_REDSTONE_OUT);
        }
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("mode", (byte)this.connectorMode.ordinal());
        tag.m_128405_("operation_speed", this.speed);
        tag.m_128405_(TAG_COLORS, this.colors);
        for (ChemicalSensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
        if (this.redstoneOut != null) {
            tag.m_128405_(TAG_REDSTONE_OUT, this.redstoneOut.intValue());
        }
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.connectorMode = ChemicalLogicEnums.ConnectorMode.values()[tag.m_128445_("mode")];
        this.speed = tag.m_128451_("operation_speed");
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.colors = tag.m_128451_(TAG_COLORS);
        for (ChemicalSensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
        this.redstoneOut = tag.m_128451_(TAG_REDSTONE_OUT);
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.connectorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalLogicEnums.ConnectorMode.SENSOR -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 26, 70, 13, 10);
            case ChemicalLogicEnums.ConnectorMode.OUTPUT -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 39, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)object, (String)"mode", (Enum)this.connectorMode);
        ChemicalLogicConnectorSettings.setIntegerSafe((JsonObject)object, (String)"operation_speed", (Integer)this.speed);
        JsonArray sensorArray = new JsonArray();
        for (ChemicalSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            sensor.writeToJson(o);
            sensorArray.add((JsonElement)o);
        }
        object.add(TAG_SENSORS, (JsonElement)sensorArray);
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.connectorMode = (ChemicalLogicEnums.ConnectorMode)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)object, (String)"mode", ChemicalLogicEnums.ConnectorMode::byName);
        this.speed = ChemicalLogicConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"operation_speed");
        JsonArray sensorArray = object.get(TAG_SENSORS).getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            ChemicalSensor sensor = new ChemicalSensor(this.sensors.size());
            sensor.readFromJson(o);
            this.sensors.add(sensor);
        }
    }
}

