/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import terrails.xnetgases.module.chemical.ChemicalEnums;

public class ChemicalLogicEnums {

    public static enum SensorOperator {
        EQUAL("=", Long::equals),
        NOTEQUAL("!=", (i1, i2) -> !i1.equals(i2)),
        LESS("<", (i1, i2) -> i1 < i2),
        GREATER(">", (i1, i2) -> i1 > i2),
        LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
        GREATEROREQUAL(">=", (i1, i2) -> i1 >= i2);

        private final String code;
        private final BiPredicate<Long, Long> matcher;
        private static final Map<String, SensorOperator> OPERATOR_MAP;
        private static final Map<String, SensorOperator> NAME_MAP;

        private SensorOperator(String code, BiPredicate<Long, Long> matcher) {
            this.code = code;
            this.matcher = matcher;
        }

        public static SensorOperator byCode(String code) {
            return OPERATOR_MAP.get(code);
        }

        public static SensorOperator byName(String name) {
            return NAME_MAP.get(name);
        }

        public boolean match(long i1, long i2) {
            return this.matcher.test(i1, i2);
        }

        public String toString() {
            return this.code;
        }

        static {
            OPERATOR_MAP = Arrays.stream(SensorOperator.values()).collect(Collectors.toMap(op -> op.code, Function.identity()));
            NAME_MAP = Arrays.stream(SensorOperator.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }

    public static enum SensorMode {
        OFF,
        GAS,
        SLURRY,
        INFUSE,
        PIGMENT;

        private static final Map<String, SensorMode> NAME_MAP;

        public static SensorMode byName(String name) {
            return NAME_MAP.get(name);
        }

        public ChemicalEnums.Type toType() {
            if (this == OFF) {
                return null;
            }
            return ChemicalEnums.Type.byName(this.name());
        }

        static {
            NAME_MAP = Arrays.stream(SensorMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }

    public static enum ConnectorMode {
        SENSOR,
        OUTPUT;

        private static final Map<String, ConnectorMode> NAME_MAP;

        public static ConnectorMode byName(String name) {
            return NAME_MAP.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            NAME_MAP = Arrays.stream(ConnectorMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }
}

