/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool.client;

import codechicken.lib.util.ClientUtils;
import com.brandon3055.aenetvistool.AENetVis;
import com.brandon3055.aenetvistool.ItemNetVisualizer;
import com.brandon3055.aenetvistool.client.ChanelRenderer;
import com.brandon3055.aenetvistool.client.NetPartRenderer;
import com.brandon3055.aenetvistool.client.P2PLinkRenderer;
import com.brandon3055.aenetvistool.data.NetworkData;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class NetRenderManager {
    private static Random rand = new Random();
    public static ItemNetVisualizer.ToolData toolData = null;
    public static NetworkData netData = null;
    public static int tick = 0;
    public static Minecraft mc = Minecraft.func_71410_x();
    public static Map<NetworkData.NetNode, NetPartRenderer> nodeMap = new WeakHashMap<NetworkData.NetNode, NetPartRenderer>();
    public static Map<NetworkData.NetNode, P2PLinkRenderer> linkMap = new WeakHashMap<NetworkData.NetNode, P2PLinkRenderer>();
    public static Map<NetworkData.NetNode, ChanelRenderer> chanelMap = new WeakHashMap<NetworkData.NetNode, ChanelRenderer>();

    public static void updateNetData(NetworkData data) {
        NetRenderManager.clearRenderers();
        netData = data;
        NetRenderManager.updateRenderers();
    }

    @SubscribeEvent
    public void clientTickStart(TickEvent.ClientTickEvent event) {
        if (!ClientUtils.inWorld() || event.phase != TickEvent.Phase.START) {
            return;
        }
        P2PLinkRenderer.FXHandler.refreshRender = true;
        ChanelRenderer.FXHandler.refreshRender = true;
        if (++tick % 10 == 0) {
            NetPartRenderer.FXHandler.refreshRender = true;
            NetRenderManager.updateRenderers();
        } else if (toolData != null) {
            ItemStack stack = HandHelper.getItem((EntityPlayer)NetRenderManager.mc.field_71439_g, (Item)AENetVis.netVisualizer);
            if (!ItemNetVisualizer.isValidTool(stack)) {
                toolData = null;
                NetRenderManager.clearRenderers();
            } else {
                ItemNetVisualizer.ToolData newData = ItemNetVisualizer.getToolData(stack);
                if (newData != null && !toolData.equals(newData)) {
                    toolData = newData;
                    NetPartRenderer.FXHandler.refreshRender = true;
                }
            }
        }
    }

    private static void updateRenderers() {
        EntityPlayerSP player = NetRenderManager.mc.field_71439_g;
        ItemStack stack = HandHelper.getItem((EntityPlayer)player, (Item)AENetVis.netVisualizer);
        if (!ItemNetVisualizer.isValidTool(stack)) {
            toolData = null;
            NetRenderManager.clearRenderers();
            return;
        }
        if (toolData == null || !NetRenderManager.toolData.id.equals(ItemNetVisualizer.getToolId(stack))) {
            toolData = ItemNetVisualizer.getToolData(stack);
        }
        if (netData != null) {
            for (NetworkData.NetNode node : NetRenderManager.netData.nodes) {
                if (node.pos.dim != player.field_71093_bK || node.pos.pos.func_177951_i((Vec3i)player.func_180425_c()) > 1024.0 && !node.forceRender()) continue;
                NetPartRenderer renderer = nodeMap.computeIfAbsent(node, netNode -> {
                    NetPartRenderer render = new NetPartRenderer((World)NetRenderManager.mc.field_71441_e, Vec3D.getCenter((BlockPos)netNode.pos.pos), node);
                    BCEffectHandler.spawnGLParticle((IGLFXHandler)render.getFXHandler(), (BCParticle)render);
                    return render;
                });
                renderer.update();
                if (node.isP2PSender && NetRenderManager.toolData.enableP2P) {
                    P2PLinkRenderer linkRenderer = linkMap.computeIfAbsent(node, netNode -> {
                        P2PLinkRenderer render = new P2PLinkRenderer((World)NetRenderManager.mc.field_71441_e, Vec3D.getCenter((BlockPos)netNode.pos.pos), node);
                        BCEffectHandler.spawnGLParticle((IGLFXHandler)render.getFXHandler(), (BCParticle)render);
                        return render;
                    });
                    linkRenderer.update();
                }
                if (node.connections.isEmpty() || !(node.pos.pos.func_177951_i((Vec3i)player.func_180425_c()) < 256.0) || !NetRenderManager.toolData.enableChanelLabels) continue;
                ChanelRenderer chanelRenderer = chanelMap.computeIfAbsent(node, netNode -> {
                    ChanelRenderer render = new ChanelRenderer((World)NetRenderManager.mc.field_71441_e, Vec3D.getCenter((BlockPos)netNode.pos.pos), node);
                    BCEffectHandler.spawnGLParticle((IGLFXHandler)render.getFXHandler(), (BCParticle)render);
                    return render;
                });
                chanelRenderer.update();
            }
        }
    }

    public static void clearRenderers() {
        nodeMap.values().forEach(Particle::func_187112_i);
        linkMap.values().forEach(Particle::func_187112_i);
        chanelMap.values().forEach(Particle::func_187112_i);
        nodeMap.clear();
        linkMap.clear();
        chanelMap.clear();
    }
}

