/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.recipe.Materialization;
import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.Materializer")
public class Materializer {
    @ZenMethod
    public static void addMaterialization(IIngredient output, IItemStack[] input) {
        Object obj = ACMT.toObject(output);
        ItemStack[] stacks = new ItemStack[input.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = ACMT.toStack(input[i]);
        }
        ACMTMisc.TASKS.add(new Add(obj, stacks));
    }

    @ZenMethod
    public static void removeMaterialization(IItemStack output) {
        ACMTMisc.TASKS.add(new Remove(ACMT.toStack(output)));
    }

    @ZenMethod
    public static void addCrystal(IItemStack stack) {
        ACMTMisc.TASKS.add(new AddCrystal(ACMT.toStack(stack)));
    }

    @ZenMethod
    public static void addCrystal(IItemStack stack, int burnTime) {
        ACMTMisc.TASKS.add(new AddCrystalFuel(ACMT.toStack(stack), burnTime));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            MaterializerRecipes.instance().getMaterializationList().clear();
        }

        public String describe() {
            return "Removing all Materializer recipes";
        }
    }

    private static class AddCrystalFuel
    implements IAction {
        private ItemStack stack;
        private int burnTime;

        public AddCrystalFuel(ItemStack stack, int burnTime) {
            this.stack = stack;
            this.burnTime = burnTime;
        }

        public void apply() {
            AbyssalCraftAPI.addCrystal((ItemStack)this.stack);
            ACMT.CRYSTALLIZER_FUELS.put(this.stack, this.burnTime);
            ACMT.TRANSMUTATOR_FUELS.put(this.stack, this.burnTime);
        }

        public String describe() {
            return String.format("Adding %s to the Crystal List, and added it as Crystallizer and Transmutator fuel (burntime: %d)", ACMT.getItemNameSafely(this.stack), this.burnTime);
        }
    }

    private static class AddCrystal
    implements IAction {
        private ItemStack stack;

        public AddCrystal(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            AbyssalCraftAPI.addCrystal((ItemStack)this.stack);
        }

        public String describe() {
            return String.format("Adding %s to the Crystal List", ACMT.getItemNameSafely(this.stack));
        }
    }

    private static class Remove
    implements IAction {
        private ItemStack output;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            ArrayList temp = Lists.newArrayList();
            if (this.output.func_77960_j() == Short.MAX_VALUE && this.output.func_77981_g()) {
                NonNullList list = NonNullList.func_191196_a();
                this.output.func_77973_b().func_150895_a(this.output.func_77973_b().func_77640_w(), list);
                list.stream().filter(Predicates.not(ItemStack::func_190926_b)).forEach(is -> {
                    for (Materialization mat : MaterializerRecipes.instance().getMaterializationList()) {
                        if (!APIUtils.areStacksEqual((ItemStack)is, (ItemStack)mat.output)) continue;
                        temp.add(mat);
                    }
                });
            } else {
                for (Materialization mat : MaterializerRecipes.instance().getMaterializationList()) {
                    if (!APIUtils.areStacksEqual((ItemStack)this.output, (ItemStack)mat.output)) continue;
                    temp.add(mat);
                }
            }
            for (Materialization mat : temp) {
                MaterializerRecipes.instance().getMaterializationList().remove(mat);
            }
        }

        public String describe() {
            return String.format("Removing Materialization recipes for %s", ACMT.getItemNameSafely(this.output));
        }
    }

    private static class Add
    implements IAction {
        private Object output;
        private ItemStack[] input;
        private String outputName;

        public Add(Object output, ItemStack[] input) {
            this.output = output;
            this.input = input;
        }

        public void apply() {
            if (this.output instanceof String) {
                this.outputName = (String)this.output;
                AbyssalCraftAPI.addMaterialization((String)this.outputName, (ItemStack[])this.input);
            } else if (this.output instanceof ItemStack) {
                ItemStack stack = (ItemStack)this.output;
                this.outputName = ACMT.getItemNameSafely(stack);
                if (stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList list = NonNullList.func_191196_a();
                    stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), list);
                    list.stream().filter(Predicates.not(ItemStack::func_190926_b)).forEach(is -> AbyssalCraftAPI.addMaterialization((ItemStack)is, (ItemStack[])this.input));
                } else {
                    AbyssalCraftAPI.addMaterialization((ItemStack)stack, (ItemStack[])this.input);
                }
            }
        }

        public String describe() {
            if (this.outputName == null) {
                return "Failed to add Materialization recipe, invalid output";
            }
            return String.format("Adding Materialization recipe for %s (input: %s)", this.outputName, this.getArrayContent(this.input));
        }

        private String getArrayContent(ItemStack[] array) {
            String stuff = "[";
            for (ItemStack stack : array) {
                stuff = stuff + ACMT.getItemNameSafely(stack) + ", ";
            }
            stuff = stuff.substring(0, stuff.length() - 2);
            stuff = stuff + "]";
            return stuff;
        }
    }
}

