/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.khnumite;

import com.google.common.base.Predicate;
import com.teammetallurgy.atum.blocks.stone.khnumite.IKhnumite;
import com.teammetallurgy.atum.entity.stone.EntityStoneguard;
import com.teammetallurgy.atum.entity.stone.EntityStonewarden;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockKhnumiteFace
extends BlockHorizontal
implements IKhnumite {
    private BlockPattern stoneguardBasePattern;
    private BlockPattern stoneguardPattern;
    private BlockPattern stonewardenBasePattern;
    private BlockPattern stonewardenPattern;

    public BlockKhnumiteFace() {
        super(Material.field_151576_e, MapColor.field_151667_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(2.0f);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.trySpawnStonemob(world, pos);
    }

    private void trySpawnStonemob(World world, BlockPos pos) {
        block11: {
            BlockPattern.PatternHelper patternHelper;
            block10: {
                patternHelper = this.getStonewardenPattern().func_177681_a(world, pos);
                if (patternHelper == null) break block10;
                for (int x = 0; x < this.getStonewardenPattern().func_177684_c(); ++x) {
                    for (int y = 0; y < this.getStonewardenPattern().func_177685_b(); ++y) {
                        BlockPos patternPos = patternHelper.func_177670_a(x, y, 0).func_177508_d();
                        if (!(world.func_180495_p(patternPos).func_177230_c() instanceof IKhnumite)) continue;
                        world.func_180501_a(patternPos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                BlockPos stonewardenPos = patternHelper.func_177670_a(1, 2, 0).func_177508_d();
                EntityStonewarden stonewarden = new EntityStonewarden(world);
                stonewarden.setPlayerCreated(true);
                stonewarden.func_180482_a(world.func_175649_E(pos), null);
                stonewarden.func_70012_b((double)stonewardenPos.func_177958_n() + 0.5, (double)stonewardenPos.func_177956_o() + 0.05, (double)stonewardenPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)stonewarden);
                for (EntityPlayerMP playerMP : world.func_72872_a(EntityPlayerMP.class, stonewarden.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(playerMP, (Entity)stonewarden);
                }
                for (int x = 0; x < this.getStonewardenPattern().func_177684_c(); ++x) {
                    for (int y = 0; y < this.getStonewardenPattern().func_177685_b(); ++y) {
                        BlockWorldState worldState1 = patternHelper.func_177670_a(x, y, 0);
                        world.func_175722_b(worldState1.func_177508_d(), Blocks.field_150350_a, false);
                    }
                }
                break block11;
            }
            patternHelper = this.getStoneguardPattern().func_177681_a(world, pos);
            if (patternHelper == null) break block11;
            for (int x = 0; x < this.getStoneguardPattern().func_177684_c(); ++x) {
                for (int y = 0; y < this.getStoneguardPattern().func_177685_b(); ++y) {
                    BlockWorldState worldState = patternHelper.func_177670_a(x, y, 0);
                    if (!(world.func_180495_p(worldState.func_177508_d()).func_177230_c() instanceof IKhnumite)) continue;
                    world.func_180501_a(worldState.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            EntityStoneguard stoneguard = new EntityStoneguard(world);
            stoneguard.setPlayerCreated(true);
            stoneguard.func_180482_a(world.func_175649_E(pos), null);
            BlockPos stoneguardPos = patternHelper.func_177670_a(0, 2, 0).func_177508_d();
            stoneguard.func_70012_b((double)stoneguardPos.func_177958_n() + 0.5, (double)stoneguardPos.func_177956_o() + 0.05, (double)stoneguardPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)stoneguard);
            for (EntityPlayerMP playerMP : world.func_72872_a(EntityPlayerMP.class, stoneguard.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(playerMP, (Entity)stoneguard);
            }
            for (int x = 0; x < this.getStoneguardPattern().func_177684_c(); ++x) {
                for (int y = 0; y < this.getStoneguardPattern().func_177685_b(); ++y) {
                    BlockWorldState worldState = patternHelper.func_177670_a(x, y, 0);
                    world.func_175722_b(worldState.func_177508_d(), Blocks.field_150350_a, false);
                }
            }
        }
    }

    @Nonnull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public static void addDispenerSupport() {
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)AtumBlocks.KHNUMITE_FACE), (Object)new Bootstrap.BehaviorDispenseOptional(){

            @Nonnull
            protected ItemStack func_82487_b(IBlockSource source, @Nonnull ItemStack stack) {
                World world = source.func_82618_k();
                BlockPos pos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                BlockKhnumiteFace khnumiteFace = (BlockKhnumiteFace)AtumBlocks.KHNUMITE_FACE;
                this.field_190911_b = true;
                if (world.func_175623_d(pos) && khnumiteFace.canDispenserPlace(world, pos)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(pos, khnumiteFace.func_176223_P(), 3);
                    }
                    stack.func_190918_g(1);
                } else {
                    ItemStack itemstack = ItemArmor.func_185082_a((IBlockSource)source, (ItemStack)stack);
                    if (itemstack.func_190926_b()) {
                        this.field_190911_b = false;
                    }
                }
                return stack;
            }
        });
    }

    private boolean canDispenserPlace(World world, BlockPos pos) {
        return this.getStonewardenBasePattern().func_177681_a(world, pos) != null || this.getStoneguardBasePattern().func_177681_a(world, pos) != null;
    }

    private BlockPattern getStoneguardBasePattern() {
        if (this.stoneguardBasePattern == null) {
            this.stoneguardBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"   ", "~#~", " # "}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stoneguardBasePattern;
    }

    private BlockPattern getStoneguardPattern() {
        if (this.stoneguardPattern == null) {
            this.stoneguardPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{" ^ ", "~#~", " # "}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_FACE))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stoneguardPattern;
    }

    private BlockPattern getStonewardenBasePattern() {
        if (this.stonewardenBasePattern == null) {
            this.stonewardenBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stonewardenBasePattern;
    }

    private BlockPattern getStonewardenPattern() {
        if (this.stonewardenPattern == null) {
            this.stonewardenPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_FACE))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stonewardenPattern;
    }
}

