/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.ModelCamel;
import com.teammetallurgy.atum.entity.animal.EntityCamel;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCamel
extends RenderLiving<EntityCamel> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private static final ResourceLocation GIRAFI = new ResourceLocation("atum", "textures/entity/camel_girafi.png");

    public RenderCamel(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelCamel(0.0f), 0.7f);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityCamel camel) {
        String textureName = camel.getTexture();
        ResourceLocation location = CACHE.get(textureName);
        if (location == null) {
            EnumDyeColor color;
            location = new ResourceLocation(textureName);
            String[] texturePath = new String[3];
            texturePath[0] = "girafi".equalsIgnoreCase(camel.func_95999_t()) ? GIRAFI.toString() : new ResourceLocation("atum", "textures/entity/camel_" + camel.getVariant()) + ".png";
            ItemStack armor = camel.getArmor();
            if (!armor.func_190926_b()) {
                EntityCamel.ArmorType armorType = EntityCamel.ArmorType.getByItemStack(armor);
                texturePath[1] = armorType.getTextureName();
            }
            if ((color = camel.getColor()) != null) {
                texturePath[2] = new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_" + color.func_192396_c()) + ".png";
            }
            Minecraft.func_71410_x().func_110434_K().func_110579_a(location, (ITextureObject)new LayeredTexture(texturePath));
            CACHE.put(textureName, location);
        }
        return location;
    }
}

