/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.ModelStonewarden;
import com.teammetallurgy.atum.entity.stone.EntityStonewarden;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderStonewarden
extends RenderLiving<EntityStonewarden> {
    private static final Map<Integer, ResourceLocation> CACHE = Maps.newHashMap();

    public RenderStonewarden(RenderManager manager) {
        super(manager, (ModelBase)new ModelStonewarden(), 0.5f);
    }

    protected void applyRotations(EntityStonewarden stonewarden, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((EntityLivingBase)stonewarden, ageInTicks, rotationYaw, partialTicks);
        if ((double)stonewarden.field_70721_aZ >= 0.01) {
            float swingValue = stonewarden.field_184619_aG - stonewarden.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float swing = (Math.abs(swingValue % 13.0f - 6.5f) - 3.25f) / 3.25f;
            GlStateManager.func_179114_b((float)(6.5f * swing), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityStonewarden stonewarden) {
        ResourceLocation location = CACHE.get(stonewarden.getVariant());
        if (location == null) {
            location = new ResourceLocation("atum", "textures/entity/stonewarden_" + stonewarden.getVariant() + ".png");
            CACHE.put(stonewarden.getVariant(), location);
        }
        return location;
    }
}

