/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei;

import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.kiln.IKilnRecipe;
import com.teammetallurgy.atum.api.recipe.quern.IQuernRecipe;
import com.teammetallurgy.atum.api.recipe.spinningwheel.ISpinningWheelRecipe;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.integration.jei.kiln.KilnRecipeCategory;
import com.teammetallurgy.atum.integration.jei.kiln.KilnRecipeWrapper;
import com.teammetallurgy.atum.integration.jei.quern.QuernRecipeCategory;
import com.teammetallurgy.atum.integration.jei.quern.QuernRecipeWrapper;
import com.teammetallurgy.atum.integration.jei.spinningwheel.SpinningWheelRecipeCategory;
import com.teammetallurgy.atum.integration.jei.spinningwheel.SpinningWheelRecipeWrapper;
import com.teammetallurgy.atum.utils.AtumRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIIntegration
implements IModPlugin {
    public static final String QUERN = "atum.quern";
    public static final String SPINNING_WHEEL = "atum.spinningwheel";
    public static final String KILN = "atum.kiln";

    public void register(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        for (ItemStack stack : AtumRegistry.HIDE_LIST) {
            blacklist.addIngredientToBlacklist((Object)stack);
        }
        registry.addRecipeCatalyst((Object)new ItemStack(AtumBlocks.QUERN), new String[]{QUERN});
        registry.handleRecipes(IQuernRecipe.class, recipe -> new QuernRecipeWrapper(registry.getJeiHelpers().getGuiHelper(), recipe.getRegistryName(), recipe.getInput(), recipe.getOutput(), recipe.getRotations()), QUERN);
        registry.addRecipes(RecipeHandlers.quernRecipes.getValuesCollection(), QUERN);
        registry.addRecipeCatalyst((Object)new ItemStack(AtumBlocks.SPINNING_WHEEL), new String[]{SPINNING_WHEEL});
        registry.handleRecipes(ISpinningWheelRecipe.class, recipe -> new SpinningWheelRecipeWrapper(recipe.getRegistryName(), recipe.getInput(), recipe.getOutput(), recipe.getRotations()), SPINNING_WHEEL);
        registry.addRecipes(RecipeHandlers.spinningWheelRecipes.getValuesCollection(), SPINNING_WHEEL);
        registry.addRecipeCatalyst((Object)new ItemStack(AtumBlocks.KILN), new String[]{KILN, "minecraft.fuel"});
        registry.handleRecipes(IKilnRecipe.class, recipe -> new KilnRecipeWrapper(recipe.getRegistryName(), recipe.getInput(), recipe.getOutput(), recipe.getExperience()), KILN);
        registry.addRecipes(RecipeHandlers.kilnRecipes.getValuesCollection(), KILN);
        registry.addRecipeCatalyst((Object)new ItemStack(AtumBlocks.LIMESTONE_FURNACE), new String[]{"minecraft.smelting", "minecraft.fuel"});
        this.addInfo(new ItemStack(AtumItems.EMMER_DOUGH), registry);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new QuernRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpinningWheelRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new KilnRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    private void addInfo(ItemStack stack, IModRegistry registry) {
        registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{"jei." + stack.func_77973_b().func_77658_a()});
    }
}

