/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.teleporter;

import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class AtumTeleporter
extends Teleporter {
    public AtumTeleporter(WorldServer worldServer) {
        super(worldServer);
    }

    public void func_180266_a(@Nonnull Entity entity, float rotationYaw) {
        if (!this.func_180620_b(entity, rotationYaw)) {
            this.func_85188_a(entity);
            this.func_180620_b(entity, rotationYaw);
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        long chunkId = ChunkPos.func_77272_a((int)MathHelper.func_76128_c((double)entity.field_70165_t), (int)MathHelper.func_76128_c((double)entity.field_70161_v));
        double distance = -1.0;
        boolean doesPortalExist = true;
        BlockPos location = BlockPos.field_177992_a;
        if (this.field_85191_c.containsKey(chunkId)) {
            Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)this.field_85191_c.get(chunkId);
            distance = 0.0;
            location = portalPosition;
            portalPosition.field_85087_d = this.field_85192_a.func_82737_E();
            doesPortalExist = false;
        } else {
            BlockPos entityPos = new BlockPos(entity);
            for (int offsetX = -128; offsetX <= 128; ++offsetX) {
                for (int offsetZ = -128; offsetZ <= 128; ++offsetZ) {
                    BlockPos currentPos = entityPos.func_177982_a(offsetX, this.field_85192_a.func_72940_L() - 1 - entityPos.func_177956_o(), offsetZ);
                    while (currentPos.func_177956_o() >= 0) {
                        BlockPos positionCache = currentPos.func_177977_b();
                        if (this.field_85192_a.func_180495_p(currentPos).func_177230_c() == AtumBlocks.PORTAL) {
                            while (this.field_85192_a.func_180495_p(positionCache = currentPos.func_177977_b()).func_177230_c() == AtumBlocks.PORTAL) {
                                currentPos = positionCache;
                            }
                            double distanceToEntity = currentPos.func_177951_i((Vec3i)entityPos);
                            if (distance < 0.0 || distanceToEntity < distance) {
                                distance = distanceToEntity;
                                location = currentPos;
                            }
                        }
                        currentPos = positionCache;
                    }
                }
            }
        }
        if (distance >= 0.0) {
            if (doesPortalExist) {
                this.field_85191_c.put(chunkId, (Object)new Teleporter.PortalPosition((Teleporter)this, location, this.field_85192_a.func_82737_E()));
            }
            double tpX = (double)location.func_177958_n() + 0.5;
            double tpY = (double)location.func_177956_o() + 0.5;
            double tpZ = (double)location.func_177952_p() + 0.5;
            EnumFacing direction = null;
            if (this.field_85192_a.func_180495_p(location.func_177976_e()).func_177230_c() == AtumBlocks.PORTAL) {
                direction = EnumFacing.NORTH;
            }
            if (this.field_85192_a.func_180495_p(location.func_177974_f()).func_177230_c() == AtumBlocks.PORTAL) {
                direction = EnumFacing.SOUTH;
            }
            if (this.field_85192_a.func_180495_p(location.func_177978_c()).func_177230_c() == AtumBlocks.PORTAL) {
                direction = EnumFacing.EAST;
            }
            if (this.field_85192_a.func_180495_p(location.func_177968_d()).func_177230_c() == AtumBlocks.PORTAL) {
                direction = EnumFacing.WEST;
            }
            EnumFacing enumfacing1 = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3));
            if (direction != null) {
                EnumFacing enumfacing2 = direction.func_176735_f();
                BlockPos blockpos2 = location.func_177972_a(direction);
                boolean flag2 = this.isInsideBlock(blockpos2);
                boolean flag3 = this.isInsideBlock(blockpos2.func_177972_a(enumfacing2));
                if (flag3 && flag2) {
                    location = location.func_177972_a(enumfacing2);
                    direction = direction.func_176734_d();
                    enumfacing2 = enumfacing2.func_176734_d();
                    BlockPos blockpos3 = location.func_177972_a(direction);
                    flag2 = this.isInsideBlock(blockpos3);
                    flag3 = this.isInsideBlock(blockpos3.func_177972_a(enumfacing2));
                }
                float f6 = 0.5f;
                float f1 = 0.5f;
                if (!flag3 && flag2) {
                    f6 = 1.0f;
                } else if (flag3 && !flag2) {
                    f6 = 0.0f;
                } else if (flag3) {
                    f1 = 0.0f;
                }
                tpX = (double)location.func_177958_n() + 0.5;
                tpY = (double)location.func_177956_o() + 0.5;
                tpZ = (double)location.func_177952_p() + 0.5;
                tpX += (double)((float)enumfacing2.func_82601_c() * f6 + (float)direction.func_82601_c() * f1);
                tpZ += (double)((float)enumfacing2.func_96559_d() * f6 + (float)direction.func_96559_d() * f1);
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                if (direction == enumfacing1) {
                    f2 = 1.0f;
                    f3 = 1.0f;
                } else if (direction == enumfacing1.func_176734_d()) {
                    f2 = -1.0f;
                    f3 = -1.0f;
                } else if (direction == enumfacing1.func_176746_e()) {
                    f4 = 1.0f;
                    f5 = -1.0f;
                } else {
                    f4 = -1.0f;
                    f5 = 1.0f;
                }
                double d2 = entity.field_70159_w;
                double d3 = entity.field_70179_y;
                entity.field_70159_w = d2 * (double)f2 + d3 * (double)f5;
                entity.field_70179_y = d2 * (double)f4 + d3 * (double)f3;
                entity.field_70177_z = rotationYaw - (float)(enumfacing1.func_176736_b() * 90) + (float)(direction.func_176736_b() * 90);
            } else {
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
            }
            entity.func_70012_b(tpX, tpY, tpZ, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return false;
    }

    private boolean isInsideBlock(BlockPos position) {
        return !this.field_85192_a.func_175623_d(position) || !this.field_85192_a.func_175623_d(position.func_177984_a());
    }

    public boolean func_85188_a(Entity entity) {
        return AtumTeleporter.createPortal((World)this.field_85192_a, new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)), entity);
    }

    public static boolean createPortal(World world, BlockPos pos, @Nullable Entity entity) {
        IBlockState portalState = AtumBlocks.PORTAL.func_176223_P();
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        while (!(world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos).func_177230_c() == AtumBlocks.SAND && world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c)) {
            pos = pos.func_177984_a();
        }
        IBlockState sandState = entity != null && entity.field_71093_bK == 0 ? Blocks.field_150322_A.func_176223_P() : BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.LARGE).func_176223_P();
        for (BlockPos.MutableBlockPos basePos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a((BlockPos)basePos, sandState, 2);
        }
        for (int y = 2; y < 4; ++y) {
            world.func_180501_a(pos.func_177982_a(-2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(-2, y, 2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, 2), sandState, 2);
        }
        for (BlockPos.MutableBlockPos portalPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            world.func_180501_a((BlockPos)portalPos, portalState, 2);
        }
        for (BlockPos.MutableBlockPos airPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)pos.func_177982_a(-2, 2, -1), (BlockPos)pos.func_177982_a(2, 3, 1))) {
            world.func_180501_a((BlockPos)airPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        return true;
    }
}

