/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util;

import com.bloodnbonesgaming.lib.util.data.MinMaxBoundsDouble;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NbtUtilExtended {
    private static final Logger LOGGER = LogManager.getLogger();

    @Nullable
    public static GameProfile readGameProfileFromNBT(NBTTagCompound compound) {
        String s = null;
        String s1 = null;
        if (compound.func_150297_b("Name", 8)) {
            s = compound.func_74779_i("Name");
        }
        if (compound.func_150297_b("Id", 8)) {
            s1 = compound.func_74779_i("Id");
        }
        try {
            UUID uuid;
            try {
                uuid = UUID.fromString(s1);
            }
            catch (Throwable var12) {
                uuid = null;
            }
            GameProfile gameprofile = new GameProfile(uuid, s);
            if (compound.func_150297_b("Properties", 10)) {
                NBTTagCompound nbttagcompound = compound.func_74775_l("Properties");
                for (String s2 : nbttagcompound.func_150296_c()) {
                    NBTTagList nbttaglist = nbttagcompound.func_150295_c(s2, 10);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                        String s3 = nbttagcompound1.func_74779_i("Value");
                        if (nbttagcompound1.func_150297_b("Signature", 8)) {
                            gameprofile.getProperties().put((Object)s2, (Object)new Property(s2, s3, nbttagcompound1.func_74779_i("Signature")));
                            continue;
                        }
                        gameprofile.getProperties().put((Object)s2, (Object)new Property(s2, s3));
                    }
                }
            }
            return gameprofile;
        }
        catch (Throwable var13) {
            return null;
        }
    }

    public static NBTTagCompound writeGameProfile(NBTTagCompound tagCompound, GameProfile profile) {
        if (!StringUtils.func_151246_b((String)profile.getName())) {
            tagCompound.func_74778_a("Name", profile.getName());
        }
        if (profile.getId() != null) {
            tagCompound.func_74778_a("Id", profile.getId().toString());
        }
        if (!profile.getProperties().isEmpty()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (String s : profile.getProperties().keySet()) {
                NBTTagList nbttaglist = new NBTTagList();
                for (Property property : profile.getProperties().get((Object)s)) {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.func_74778_a("Value", property.getValue());
                    if (property.hasSignature()) {
                        nbttagcompound1.func_74778_a("Signature", property.getSignature());
                    }
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                }
                nbttagcompound.func_74782_a(s, (NBTBase)nbttaglist);
            }
            tagCompound.func_74782_a("Properties", (NBTBase)nbttagcompound);
        }
        return tagCompound;
    }

    @VisibleForTesting
    public static boolean areNBTEquals(NBTBase nbt1, NBTBase nbt2, boolean compareTagList) {
        if (nbt1 == nbt2) {
            return true;
        }
        if (nbt1 == null) {
            return true;
        }
        if (nbt2 == null) {
            return false;
        }
        if (nbt1 instanceof NBTTagString && (nbt2 instanceof NBTTagFloat || nbt2 instanceof NBTTagByte || nbt2 instanceof NBTTagLong || nbt2 instanceof NBTTagShort || nbt2 instanceof NBTTagInt || nbt2 instanceof NBTTagDouble)) {
            float nbtValue;
            if (nbt2 instanceof NBTTagFloat) {
                nbtValue = ((NBTTagFloat)nbt2).func_150288_h();
            } else if (nbt2 instanceof NBTTagByte) {
                nbtValue = ((NBTTagByte)nbt2).func_150288_h();
            } else if (nbt2 instanceof NBTTagLong) {
                nbtValue = ((NBTTagLong)nbt2).func_150288_h();
            } else if (nbt2 instanceof NBTTagShort) {
                nbtValue = ((NBTTagShort)nbt2).func_150288_h();
            } else if (nbt2 instanceof NBTTagInt) {
                nbtValue = ((NBTTagInt)nbt2).func_150288_h();
            } else if (nbt2 instanceof NBTTagDouble) {
                nbtValue = ((NBTTagDouble)nbt2).func_150288_h();
            } else {
                return nbt1.equals((Object)nbt2);
            }
            String string = ((NBTTagString)nbt1).func_150285_a_();
            if (string.contains("~")) {
                if (string.startsWith("~")) {
                    String max = string.substring(1).trim();
                    if (NumberUtils.isCreatable((String)max)) {
                        MinMaxBoundsDouble bounds = new MinMaxBoundsDouble(null, NumberUtils.createNumber((String)max).doubleValue());
                        return bounds.func_192514_a(nbtValue);
                    }
                } else if (string.endsWith("~")) {
                    String min = string.substring(0, string.length() - 1);
                    if (NumberUtils.isCreatable((String)min)) {
                        MinMaxBoundsDouble bounds = new MinMaxBoundsDouble(NumberUtils.createNumber((String)min).doubleValue(), null);
                        return bounds.func_192514_a(nbtValue);
                    }
                } else {
                    String[] split = string.split("~");
                    if (NumberUtils.isCreatable((String)split[0].trim()) && NumberUtils.isCreatable((String)split[1].trim())) {
                        MinMaxBoundsDouble bounds = new MinMaxBoundsDouble(NumberUtils.createNumber((String)split[0]).doubleValue(), NumberUtils.createNumber((String)split[1]).doubleValue());
                        return bounds.func_192514_a(nbtValue);
                    }
                }
            } else if (NumberUtils.isCreatable((String)string)) {
                MinMaxBoundsDouble bounds = new MinMaxBoundsDouble(NumberUtils.createNumber((String)string).doubleValue(), NumberUtils.createNumber((String)string).doubleValue());
                return bounds.func_192514_a(nbtValue);
            }
        } else {
            if (!nbt1.getClass().equals(nbt2.getClass())) {
                return false;
            }
            if (nbt1 instanceof NBTTagCompound) {
                NBTTagCompound nbttagcompound = (NBTTagCompound)nbt1;
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbt2;
                for (String s : nbttagcompound.func_150296_c()) {
                    NBTBase nbtbase1 = nbttagcompound.func_74781_a(s);
                    if (NbtUtilExtended.areNBTEquals(nbtbase1, nbttagcompound1.func_74781_a(s), compareTagList)) continue;
                    return false;
                }
                return true;
            }
            if (nbt1 instanceof NBTTagList && compareTagList) {
                NBTTagList nbttaglist = (NBTTagList)nbt1;
                NBTTagList nbttaglist1 = (NBTTagList)nbt2;
                if (nbttaglist.func_82582_d()) {
                    return nbttaglist1.func_82582_d();
                }
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTBase nbtbase = nbttaglist.func_179238_g(i);
                    boolean flag = false;
                    for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                        if (!NbtUtilExtended.areNBTEquals(nbtbase, nbttaglist1.func_179238_g(j), compareTagList)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                return true;
            }
        }
        return nbt1.equals((Object)nbt2);
    }

    public static NBTTagCompound createUUIDTag(UUID uuid) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74772_a("M", uuid.getMostSignificantBits());
        nbttagcompound.func_74772_a("L", uuid.getLeastSignificantBits());
        return nbttagcompound;
    }

    public static UUID getUUIDFromTag(NBTTagCompound tag) {
        return new UUID(tag.func_74763_f("M"), tag.func_74763_f("L"));
    }

    public static BlockPos getPosFromTag(NBTTagCompound tag) {
        return new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }

    public static NBTTagCompound createPosTag(BlockPos pos) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("X", pos.func_177958_n());
        nbttagcompound.func_74768_a("Y", pos.func_177956_o());
        nbttagcompound.func_74768_a("Z", pos.func_177952_p());
        return nbttagcompound;
    }

    public static IBlockState readBlockState(NBTTagCompound tag) {
        if (!tag.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("Name")));
        IBlockState iblockstate = block.func_176223_P();
        if (tag.func_150297_b("Properties", 10)) {
            NBTTagCompound nbttagcompound = tag.func_74775_l("Properties");
            BlockStateContainer blockstatecontainer = block.func_176194_O();
            for (String s : nbttagcompound.func_150296_c()) {
                IProperty iproperty = blockstatecontainer.func_185920_a(s);
                if (iproperty == null) continue;
                iblockstate = NbtUtilExtended.setValueHelper(iblockstate, iproperty, s, nbttagcompound, tag);
            }
        }
        return iblockstate;
    }

    private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState p_193590_0_, IProperty<T> p_193590_1_, String p_193590_2_, NBTTagCompound p_193590_3_, NBTTagCompound p_193590_4_) {
        Optional optional = p_193590_1_.func_185929_b(p_193590_3_.func_74779_i(p_193590_2_));
        if (optional.isPresent()) {
            return p_193590_0_.func_177226_a(p_193590_1_, (Comparable)optional.get());
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)p_193590_2_, (Object)p_193590_3_.func_74779_i(p_193590_2_), (Object)p_193590_4_.toString());
        return p_193590_0_;
    }

    public static NBTTagCompound writeBlockState(NBTTagCompound tag, IBlockState state) {
        tag.func_74778_a("Name", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString());
        if (!state.func_177228_b().isEmpty()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                IProperty iproperty = (IProperty)entry.getKey();
                nbttagcompound.func_74778_a(iproperty.func_177701_a(), NbtUtilExtended.getName(iproperty, (Comparable)entry.getValue()));
            }
            tag.func_74782_a("Properties", (NBTBase)nbttagcompound);
        }
        return tag;
    }

    private static <T extends Comparable<T>> String getName(IProperty<T> p_190010_0_, Comparable<?> p_190010_1_) {
        return p_190010_0_.func_177702_a(p_190010_1_);
    }
}

