/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import wanion.biggercraftingtables.BiggerCraftingTables;
import wanion.biggercraftingtables.Reference;
import wanion.biggercraftingtables.block.TileEntityBiggerCreatingTable;
import wanion.biggercraftingtables.block.big.TileEntityBigCreatingTable;
import wanion.biggercraftingtables.block.giant.TileEntityGiantCreatingTable;
import wanion.biggercraftingtables.block.huge.TileEntityHugeCreatingTable;

public final class BlockBiggerCreatingTable
extends BlockContainer {
    public static final BlockBiggerCreatingTable INSTANCE = new BlockBiggerCreatingTable();

    private BlockBiggerCreatingTable() {
        super(Material.field_151575_d);
        this.field_149763_I = 0.0f;
        this.func_149711_c(2.5f).func_149647_a(BiggerCraftingTables.creativeTabs);
        this.setRegistryName(new ResourceLocation("biggercraftingtables", "biggercreatingtable"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(Reference.TABLE_TYPES, (Comparable)Reference.TableTypes.BIG));
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityBigCreatingTable();
            }
            case 1: {
                return new TileEntityHugeCreatingTable();
            }
            case 2: {
                return new TileEntityGiantCreatingTable();
            }
        }
        return null;
    }

    public IBlockState func_176203_a(int metadata) {
        return this.func_176223_P().func_177226_a(Reference.TABLE_TYPES, (Comparable)Reference.TableTypes.getByValue(metadata));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((Reference.TableTypes)blockState.func_177229_b(Reference.TABLE_TYPES)).getMetadata();
    }

    @Nonnull
    public Item func_180660_a(IBlockState blockState, Random random, int fortune) {
        return Items.field_190931_a;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world != null) {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity instanceof TileEntityBigCreatingTable) {
                FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)BiggerCraftingTables.instance, (int)2, (World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
            } else if (tileEntity instanceof TileEntityHugeCreatingTable) {
                FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)BiggerCraftingTables.instance, (int)5, (World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
            } else if (tileEntity instanceof TileEntityGiantCreatingTable) {
                FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)BiggerCraftingTables.instance, (int)8, (World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
            } else {
                return false;
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (world == null) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityBiggerCreatingTable && itemStack.func_77942_o()) {
            ((TileEntityBiggerCreatingTable)tileEntity).readCustomNBT(itemStack.func_77978_p());
        }
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> items) {
        if (creativeTabs == this.func_149708_J()) {
            for (int i = 0; i < Reference.TableTypes.values().length; ++i) {
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Reference.TABLE_TYPES});
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185848_a;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (world == null) {
            return;
        }
        TileEntityBiggerCreatingTable tileEntityBiggerCreatingTable = (TileEntityBiggerCreatingTable)world.func_175625_s(blockPos);
        if (tileEntityBiggerCreatingTable != null) {
            ItemStack droppedStack = new ItemStack((Block)this, 1, this.func_176201_c(blockState));
            NBTTagCompound nbtTagCompound = tileEntityBiggerCreatingTable.writeCustomNBT(new NBTTagCompound());
            if (nbtTagCompound.func_150295_c("Contents", 10).func_74745_c() > 0) {
                droppedStack.func_77982_d(nbtTagCompound);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)((float)blockPos.func_177958_n() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177956_o() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177952_p() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), droppedStack));
        }
        super.func_180663_b(world, blockPos, blockState);
    }
}

