/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.biggercraftingtables.block.TileEntityBiggerCreatingTable;
import wanion.biggercraftingtables.client.button.ClearShapeButton;
import wanion.biggercraftingtables.client.button.CopyToClipBoardButton;
import wanion.biggercraftingtables.client.button.ExportToFileButton;
import wanion.biggercraftingtables.client.button.ShapeControlWButton;
import wanion.biggercraftingtables.common.control.ShapeControl;
import wanion.lib.client.ClientHelper;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.common.IClickAction;
import wanion.lib.common.WContainer;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.inventory.slot.MatchingSlot;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBiggerCreatingTable<T extends TileEntityBiggerCreatingTable<?>>
extends WGuiContainer<T> {
    private final Slot firstPlayerSlot;
    private final Slot outputSlot;
    private final List<String> matchingDescription;
    private final List<String> outputDescription;
    private final ShapeControlWButton shapeControlWButton;

    public GuiBiggerCreatingTable(@Nonnull WContainer<T> container, @Nonnull ResourceLocation guiTexture) {
        super(container, guiTexture);
        this.firstPlayerSlot = this.field_147002_h.func_75139_a(this.field_147002_h.field_75151_b.size() - 36);
        this.outputSlot = this.field_147002_h.func_75139_a(this.firstPlayerSlot.field_75222_d - 1);
        this.matchingDescription = Arrays.asList(ClientHelper.getHowToUse(), TextFormatting.GRAY + I18n.func_135052_a((String)"wanionlib.matching.desc", (Object[])new Object[0]));
        this.outputDescription = Arrays.asList("", TextFormatting.GOLD + I18n.func_135052_a((String)"bigger.creating.usage", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"bigger.creating.usage.desc.line1", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"bigger.creating.usage.desc.line2", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"bigger.creating.usage.desc.line3", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"bigger.creating.usage.desc.line4", (Object[])new Object[0]));
        this.shapeControlWButton = new ShapeControlWButton((ShapeControl)this.getControl(ShapeControl.class), this, this.field_147003_i + this.outputSlot.field_75223_e - 10, this.field_147009_r + this.outputSlot.field_75221_f - 28);
        this.addElement((WElement)this.shapeControlWButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new ClearShapeButton(1, (GuiContainer)this, this.shapeControlWButton.getUsableX() + 22, this.shapeControlWButton.getUsableY() + 5));
        this.func_189646_b(new ExportToFileButton(2, this, this.field_147003_i + this.outputSlot.field_75223_e - 1, this.field_147009_r + this.outputSlot.field_75221_f + 23));
        this.func_189646_b(new CopyToClipBoardButton(3, this, this.field_147003_i + this.outputSlot.field_75223_e + 9, this.field_147009_r + this.outputSlot.field_75221_f + 23));
    }

    protected final void func_146285_a(@Nonnull ItemStack stack, int x, int y) {
        MatchingSlot matchingSlot = this.findSlot(x, y);
        if (matchingSlot != null) {
            this.drawMatchingTooltip(matchingSlot, stack, x, y);
        } else if (super.func_146978_c(this.outputSlot.field_75223_e, this.outputSlot.field_75221_f, 16, 16, x, y)) {
            this.drawOutputSlotToolTip(stack, x, y);
        } else {
            super.func_146285_a(stack, x, y);
        }
    }

    private MatchingSlot findSlot(int x, int y) {
        int max = this.field_147002_h.field_75151_b.size() - 37;
        for (int i = 0; i < max; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (!(slot instanceof MatchingSlot) || !super.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, x, y)) continue;
            return (MatchingSlot)slot;
        }
        return null;
    }

    private void drawMatchingTooltip(@Nonnull MatchingSlot matchingSlot, @Nonnull ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List toolTip = this.func_191927_a(stack);
        AbstractMatching matching = matchingSlot.getMatching();
        toolTip.add("");
        toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)matching.getControlName(), (Object[])new Object[0]) + ": " + TextFormatting.WHITE + matching.getMatcher().getDescription());
        toolTip.addAll(this.matchingDescription);
        this.drawHoveringText(toolTip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    private void drawOutputSlotToolTip(@Nonnull ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List toolTip = this.func_191927_a(stack);
        toolTip.addAll(this.outputDescription);
        this.drawHoveringText(toolTip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        block3: {
            block2: {
                if (mouseButton == 0) break block2;
                if (mouseButton != 1) break block3;
            }
            this.field_146292_n.stream().filter(IClickAction.class::isInstance).forEach(button -> {
                if (button.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                    ((IClickAction)button).action(mouseButton == 0);
                }
            });
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }
}

