/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import gnu.trove.TIntCollection;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import wanion.biggercraftingtables.Config;
import wanion.lib.common.MetaItem;
import wanion.lib.common.WTileEntity;
import wanion.lib.common.control.ControlController;
import wanion.lib.common.control.IControl;
import wanion.lib.common.control.energy.EnergyControl;
import wanion.lib.common.control.redstone.RedstoneControl;
import wanion.lib.recipe.advanced.AbstractRecipeRegistry;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class TileEntityAutoBiggerCraftingTable<R extends IAdvancedRecipe>
extends WTileEntity
implements ITickable {
    public final int full = this.func_70302_i_() - 2;
    public final int half = this.full / 2;
    public final int powerConsumption;
    public final RedstoneControl redstoneControl;
    public final EnergyControl energyControl;
    private final BiggerCraftingMatrix biggerCraftingMatrix;
    private final ControlController controlController;
    private R cachedRecipe;
    private TIntIntMap patternMap;

    protected TileEntityAutoBiggerCraftingTable() {
        this.powerConsumption = this.half * Config.INSTANCE.powerMultiplier;
        this.biggerCraftingMatrix = new BiggerCraftingMatrix((int)Math.sqrt(this.half));
        this.cachedRecipe = null;
        this.patternMap = null;
        this.controlController = (ControlController)this.getController(ControlController.class);
        this.redstoneControl = new RedstoneControl((TileEntity)this);
        this.controlController.add((Object)this.redstoneControl);
        this.energyControl = new EnergyControl(this.powerConsumption * Config.INSTANCE.capacityMultiplier, this.powerConsumption);
        this.controlController.add((Object)this.energyControl);
        this.addCapability(CapabilityEnergy.ENERGY, this.energyControl);
        this.addCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerAutoBiggerCraftingTable(this));
        this.recipeShapeChanged();
    }

    public final void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Collection allControls = this.controlController.getInstances();
        if (!allControls.stream().allMatch(IControl::canOperate)) {
            return;
        }
        if (this.cachedRecipe == null) {
            if (this.patternMap != null) {
                this.patternMap = null;
            }
            return;
        }
        ItemStack recipeStack = (ItemStack)this.itemStacks.get(this.func_70302_i_() - 1);
        ItemStack outputStack = (ItemStack)this.itemStacks.get(this.func_70302_i_() - 2);
        if (recipeStack.func_190926_b() || !outputStack.func_190926_b() && outputStack.func_190916_E() == outputStack.func_77976_d()) {
            return;
        }
        if (this.patternMap == null) {
            this.patternMap = MetaItem.getKeySizeMap((int)this.half, (int)this.full, (NonNullList)this.itemStacks);
        }
        if (outputStack.func_190926_b() && this.notMatches(MetaItem.getSmartKeySizeMap((int)0, (int)this.half, (NonNullList)this.itemStacks), this.patternMap)) {
            return;
        }
        if (!outputStack.func_190926_b() && outputStack.func_190916_E() + recipeStack.func_190916_E() > outputStack.func_77976_d() || this.notMatches(MetaItem.getSmartKeySizeMap((int)0, (int)this.half, (NonNullList)this.itemStacks), this.patternMap)) {
            return;
        }
        allControls.forEach(IControl::operate);
        this.cleanInput();
        if (outputStack.func_190926_b()) {
            this.itemStacks.set(this.func_70302_i_() - 2, (Object)recipeStack.func_77946_l());
        } else {
            outputStack.func_190920_e(outputStack.func_190916_E() + recipeStack.func_190916_E());
        }
        this.func_70296_d();
    }

    private boolean notMatches(@Nonnull TIntIntMap inputMap, @Nonnull TIntIntMap patternMap) {
        if (inputMap.size() >= patternMap.size() && inputMap.keySet().containsAll((TIntCollection)patternMap.keySet())) {
            for (int key : patternMap.keys()) {
                if (inputMap.get(key) >= patternMap.get(key)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void cleanInput() {
        TIntIntHashMap patternMap = new TIntIntHashMap(this.patternMap);
        for (int i = 0; i < this.half && !patternMap.isEmpty(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemStacks.get(i);
            int key = MetaItem.get((ItemStack)itemStack);
            if (!patternMap.containsKey(key)) continue;
            int total = patternMap.get(key);
            int dif = MathHelper.func_76125_a((int)total, (int)1, (int)itemStack.func_190916_E());
            if (itemStack.func_77973_b() == Items.field_151131_as || itemStack.func_77973_b() == Items.field_151129_at || itemStack.func_77973_b() instanceof UniversalBucket) {
                this.func_70299_a(i, new ItemStack(Items.field_151133_ar));
            } else if (!itemStack.func_77973_b().hasContainerItem(itemStack)) {
                itemStack.func_190920_e(itemStack.func_190916_E() - dif);
            }
            if (dif - total == 0) {
                patternMap.remove(key);
            } else {
                patternMap.put(key, total - dif);
            }
            if (itemStack.func_190916_E() != 0) continue;
            this.itemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public abstract AbstractRecipeRegistry<R> getRecipeRegistry();

    public void readCustomNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        super.readCustomNBT(nbtTagCompound);
        this.recipeShapeChanged();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemStack) {
        return true;
    }

    final void recipeShapeChanged() {
        IAdvancedRecipe matchedRecipe = this.getRecipeRegistry().findMatchingRecipe((InventoryCrafting)this.biggerCraftingMatrix);
        this.itemStacks.set(this.func_70302_i_() - 1, (Object)((this.cachedRecipe = matchedRecipe) != null ? this.cachedRecipe.getOutput().func_77946_l() : ItemStack.field_190927_a));
        this.patternMap = null;
    }

    private static class ItemHandlerAutoBiggerCraftingTable
    extends InvWrapper {
        private final TileEntityAutoBiggerCraftingTable<? extends IAdvancedRecipe> tileEntityAutoBiggerCraftingTable;

        private ItemHandlerAutoBiggerCraftingTable(@Nonnull TileEntityAutoBiggerCraftingTable<? extends IAdvancedRecipe> tileEntityAutoBiggerCraftingTable) {
            super(tileEntityAutoBiggerCraftingTable);
            this.tileEntityAutoBiggerCraftingTable = tileEntityAutoBiggerCraftingTable;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot >= this.tileEntityAutoBiggerCraftingTable.half ? stack : super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack slotStack;
            boolean full = slot == this.tileEntityAutoBiggerCraftingTable.full;
            ItemStack itemStack = slotStack = simulate ? this.getStackInSlot(slot).func_77946_l() : this.getStackInSlot(slot);
            if (full || slotStack.func_77973_b() == Items.field_151133_ar) {
                if (slotStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                ItemStack newStack = slotStack.func_77946_l();
                int newStackSize = MathHelper.func_76125_a((int)amount, (int)1, (int)newStack.func_190916_E());
                newStack.func_190920_e(newStackSize);
                slotStack.func_190920_e(slotStack.func_190916_E() - newStackSize);
                if (!simulate && slotStack.func_190926_b()) {
                    this.setStackInSlot(slot, ItemStack.field_190927_a);
                    this.getInv().func_70296_d();
                }
                return newStack;
            }
            return ItemStack.field_190927_a;
        }
    }

    private final class BiggerCraftingMatrix
    extends InventoryCrafting {
        final int square;

        private BiggerCraftingMatrix(int squareRoot) {
            super(new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer entityPlayer) {
                    return false;
                }
            }, squareRoot, squareRoot);
            this.square = squareRoot * squareRoot;
        }

        @Nonnull
        public ItemStack func_70301_a(int slot) {
            return (ItemStack)TileEntityAutoBiggerCraftingTable.this.itemStacks.get(this.square + slot);
        }
    }
}

