/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.client.button;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import wanion.biggercraftingtables.Reference;
import wanion.biggercraftingtables.block.GuiBiggerCreatingTable;
import wanion.biggercraftingtables.block.TileEntityBiggerCreatingTable;
import wanion.biggercraftingtables.common.CTUtils;
import wanion.lib.client.ClientHelper;
import wanion.lib.common.IClickAction;

@SideOnly(value=Side.CLIENT)
public final class ExportToFileButton
extends GuiButton
implements IClickAction {
    private final ResourceLocation resourceLocation = Reference.GUI_TEXTURES;
    private final TileEntityBiggerCreatingTable<?> tileEntityBiggerCreatingTable;
    private final GuiBiggerCreatingTable<? extends TileEntityBiggerCreatingTable<?>> guiBiggerCreatingTable;
    private final File scriptFile;
    private final List<String> baseDescription = new ArrayList<String>();
    private final Slot outputSlot;
    private String script = "";
    private boolean success = false;

    public ExportToFileButton(int buttonId, @Nonnull GuiBiggerCreatingTable<? extends TileEntityBiggerCreatingTable<?>> guiBiggerCreatingTable, int x, int y) {
        super(buttonId, x, y, 9, 9, "");
        this.guiBiggerCreatingTable = guiBiggerCreatingTable;
        this.tileEntityBiggerCreatingTable = (TileEntityBiggerCreatingTable)guiBiggerCreatingTable.getContainer().getTile();
        String scriptName = "scripts" + Reference.SLASH + this.tileEntityBiggerCreatingTable.getTableType().func_176610_l() + "Recipes.zs";
        this.scriptFile = new File("." + Reference.SLASH + scriptName);
        this.baseDescription.add(TextFormatting.RED + I18n.func_135052_a((String)"bigger.creating.export", (Object[])new Object[0]) + " " + TextFormatting.GOLD + "\u00e2\u20ac\u0153" + scriptName.replace('\\', '/') + "\u00e2\u20ac\ufffd");
        this.outputSlot = guiBiggerCreatingTable.field_147002_h.func_75139_a(guiBiggerCreatingTable.field_147002_h.field_75151_b.size() - 37);
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.resourceLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        if (this.success && !this.field_146123_n) {
            this.success = false;
        }
        ExportToFileButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)(!this.func_146115_a() ? 0.0f : 9.0f), (float)38.0f, (int)this.field_146120_f, (int)this.field_146121_g, (float)128.0f, (float)128.0f);
    }

    public void func_146111_b(int mouseX, int mouseY) {
        ArrayList<String> description = new ArrayList<String>(this.baseDescription);
        if (!this.success) {
            String script;
            ArrayList<String> problems = new ArrayList<String>();
            if (this.isEmpty()) {
                problems.add(I18n.func_135052_a((String)"bigger.creating.export.empty", (Object[])new Object[0]));
            }
            if (!this.outputSlot.func_75216_d()) {
                problems.add(I18n.func_135052_a((String)"bigger.creating.export.no-output", (Object[])new Object[0]));
            }
            if (this.script.equals(script = CTUtils.toCTScript(this.tileEntityBiggerCreatingTable))) {
                problems.add(I18n.func_135052_a((String)"bigger.creating.export.no-changes", (Object[])new Object[0]));
            }
            if (!problems.isEmpty()) {
                description.add(ClientHelper.getProblemFound((problems.size() > 1 ? 1 : 0) != 0));
                description.addAll(problems);
            }
        } else {
            description.add(ClientHelper.getSuccess());
        }
        this.guiBiggerCreatingTable.func_146283_a(description, mouseX - this.guiBiggerCreatingTable.getGuiLeft(), mouseY - this.guiBiggerCreatingTable.getGuiTop());
    }

    public void action(boolean b) {
        if (!b) {
            return;
        }
        if (this.success) {
            this.success = false;
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        String script = CTUtils.toCTScript(this.tileEntityBiggerCreatingTable);
        if (this.script != null && script != null && !this.script.equals(script)) {
            this.func_146113_a(this.guiBiggerCreatingTable.field_146297_k.func_147118_V());
            this.script = script;
            try {
                FileUtils.writeStringToFile((File)this.scriptFile, (String)script, (Charset)Charset.defaultCharset(), (boolean)true);
                this.success = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isEmpty() {
        int max = this.tileEntityBiggerCreatingTable.func_70302_i_() - 1;
        for (int i = 0; i < max; ++i) {
            if (this.tileEntityBiggerCreatingTable.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

