/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.handler;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.custom_hash.TObjectByteCustomHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.biometweaker.common.world.gen.BlockReplacer;
import me.superckl.biometweaker.common.world.gen.Decorator;
import me.superckl.biometweaker.common.world.gen.PlacementStage;
import me.superckl.biometweaker.common.world.gen.layer.GenLayerReplacement;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeEventHandler {
    public static byte globalSize = (byte)-1;
    public static final TObjectByteCustomHashMap<Object> sizes = new TObjectByteCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    private static final TIntObjectMap<List<Pair<IBlockState, IBlockState>>> villageBlockReplacements = new TIntObjectHashMap();
    private static final TIntObjectMap<List<String>> decorateTypes = new TIntObjectHashMap();
    private static final TIntObjectMap<List<String>> populateTypes = new TIntObjectHashMap();
    private static final TIntObjectMap<List<String>> oreTypes = new TIntObjectHashMap();
    private static final Map<DecorateBiomeEvent.Decorate.EventType, TIntIntMap> decorationsPerChunk = new EnumMap<DecorateBiomeEvent.Decorate.EventType, TIntIntMap>(DecorateBiomeEvent.Decorate.EventType.class);
    private final int[] colorCache = new int[512];

    public BiomeEventHandler() {
        Arrays.fill(this.colorCache, -2);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onReplaceBlocks(ChunkGeneratorEvent.ReplaceBiomeBlocks e) {
        BlockReplacer.runReplacement(PlacementStage.BIOME_BLOCKS, e.getWorld(), e.getWorld().field_73012_v, new ChunkPos(e.getX(), e.getZ()), e.getPrimer());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPrePopulateBiome(PopulateChunkEvent.Pre e) {
        Decorator.runDecoration(PlacementStage.PRE_POPULATE, e.getWorld(), e.getRand(), new ChunkPos(e.getChunkX(), e.getChunkZ()));
        BlockReplacer.runReplacement(PlacementStage.PRE_POPULATE, e.getWorld(), e.getRand(), new ChunkPos(e.getChunkX(), e.getChunkZ()), null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPostPopulateBiome(PopulateChunkEvent.Post e) {
        Decorator.runDecoration(PlacementStage.POST_POPULATE, e.getWorld(), e.getRand(), new ChunkPos(e.getChunkX(), e.getChunkZ()));
        BlockReplacer.runReplacement(PlacementStage.POST_POPULATE, e.getWorld(), e.getRand(), new ChunkPos(e.getChunkX(), e.getChunkZ()), null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreDecorateBiome(DecorateBiomeEvent.Pre e) {
        Decorator.runDecoration(PlacementStage.PRE_DECORATE, e.getWorld(), e.getRand(), e.getChunkPos());
        BlockReplacer.runReplacement(PlacementStage.PRE_DECORATE, e.getWorld(), e.getRand(), e.getChunkPos(), null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreGenerateOres(OreGenEvent.Pre e) {
        Decorator.runDecoration(PlacementStage.PRE_ORES, e.getWorld(), e.getRand(), new ChunkPos(e.getPos()));
        BlockReplacer.runReplacement(PlacementStage.PRE_ORES, e.getWorld(), e.getRand(), new ChunkPos(e.getPos()), null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreGenerateOres(OreGenEvent.Post e) {
        Decorator.runDecoration(PlacementStage.POST_ORES, e.getWorld(), e.getRand(), new ChunkPos(e.getPos()));
        BlockReplacer.runReplacement(PlacementStage.POST_ORES, e.getWorld(), e.getRand(), new ChunkPos(e.getPos()), null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPostDecorateBiome(DecorateBiomeEvent.Post e) {
        Decorator.runDecoration(PlacementStage.POST_DECORATE, e.getWorld(), e.getRand(), e.getChunkPos());
        BlockReplacer.runReplacement(PlacementStage.POST_DECORATE, e.getWorld(), e.getRand(), e.getChunkPos(), null);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetGrassColor(BiomeEvent.GetGrassColor e) {
        if (BiomePropertyManager.GRASS_COLOR == null) {
            return;
        }
        try {
            int id = Biome.func_185362_a((Biome)e.getBiome());
            int newColor = this.colorCache[id];
            if (newColor == -1) {
                return;
            }
            newColor = this.colorCache[id];
            if (newColor != -2) {
                e.setNewColor(newColor);
            } else {
                this.colorCache[id] = newColor = BiomePropertyManager.GRASS_COLOR.get(e.getBiome()).intValue();
                if (newColor == -1) {
                    return;
                }
                e.setNewColor(newColor);
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getGrassColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGetFoliageColor(BiomeEvent.GetFoliageColor e) {
        if (BiomePropertyManager.FOLIAGE_COLOR == null) {
            return;
        }
        try {
            int id = Biome.func_185362_a((Biome)e.getBiome());
            int newColor = this.colorCache[id + 256];
            if (newColor == -1) {
                return;
            }
            newColor = this.colorCache[id + 256];
            if (newColor != -2) {
                e.setNewColor(newColor);
            } else {
                this.colorCache[id + 256] = newColor = BiomePropertyManager.FOLIAGE_COLOR.get(e.getBiome()).intValue();
                if (newColor == -1) {
                    return;
                }
                e.setNewColor(newColor);
            }
        }
        catch (Exception e1) {
            LogHelper.error("Failed to process getFoliageColor event!");
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeDecorate(DecorateBiomeEvent.Decorate e) {
        if (decorateTypes.isEmpty()) {
            return;
        }
        Biome gen = e.getWorld().func_180494_b(e.getChunkPos().func_180331_a(0, 0, 0));
        if (decorateTypes.containsKey(Biome.func_185362_a((Biome)gen)) && (((List)decorateTypes.get(Biome.func_185362_a((Biome)gen))).contains(e.getType().name()) || ((List)decorateTypes.get(Biome.func_185362_a((Biome)gen))).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomePopulate(PopulateChunkEvent.Populate e) {
        if (populateTypes.isEmpty()) {
            return;
        }
        Biome gen = e.getWorld().func_180494_b(new ChunkPos(e.getChunkX(), e.getChunkZ()).func_180331_a(8, 0, 8));
        if (populateTypes.containsKey(Biome.func_185362_a((Biome)gen)) && (((List)populateTypes.get(Biome.func_185362_a((Biome)gen))).contains(e.getType().name()) || ((List)populateTypes.get(Biome.func_185362_a((Biome)gen))).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onOreGen(OreGenEvent.GenerateMinable e) {
        if (oreTypes.isEmpty()) {
            return;
        }
        Biome gen = e.getWorld().func_180494_b(e.getPos());
        if (oreTypes.containsKey(Biome.func_185362_a((Biome)gen)) && (((List)oreTypes.get(Biome.func_185362_a((Biome)gen))).contains(e.getType().name()) || ((List)oreTypes.get(Biome.func_185362_a((Biome)gen))).contains("all"))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCreateBiomeDecorator(BiomeEvent.CreateDecorator e) {
        int id = Biome.func_185362_a((Biome)e.getBiome());
        for (Map.Entry<DecorateBiomeEvent.Decorate.EventType, TIntIntMap> entry : decorationsPerChunk.entrySet()) {
            if (!entry.getValue().containsKey(id)) continue;
            switch (entry.getKey()) {
                case LILYPAD: {
                    e.getNewBiomeDecorator().field_76833_y = entry.getValue().get(id);
                    break;
                }
                case TREE: {
                    e.getNewBiomeDecorator().field_76832_z = entry.getValue().get(id);
                    break;
                }
                case FLOWERS: {
                    e.getNewBiomeDecorator().field_76802_A = entry.getValue().get(id);
                    break;
                }
                case GRASS: {
                    e.getNewBiomeDecorator().field_76803_B = entry.getValue().get(id);
                    break;
                }
                case DEAD_BUSH: {
                    e.getNewBiomeDecorator().field_76804_C = entry.getValue().get(id);
                    break;
                }
                case SHROOM: {
                    e.getNewBiomeDecorator().field_76798_D = entry.getValue().get(id);
                    break;
                }
                case REED: {
                    e.getNewBiomeDecorator().field_76799_E = entry.getValue().get(id);
                    break;
                }
                case CACTUS: {
                    e.getNewBiomeDecorator().field_76800_F = entry.getValue().get(id);
                    break;
                }
                case SAND: {
                    e.getNewBiomeDecorator().field_76805_H = entry.getValue().get(id);
                    break;
                }
                case CLAY: {
                    e.getNewBiomeDecorator().field_76806_I = entry.getValue().get(id);
                    break;
                }
                case BIG_SHROOM: {
                    e.getNewBiomeDecorator().field_76807_J = entry.getValue().get(id);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onGetBiomeSize(WorldTypeEvent.BiomeSize e) {
        if (globalSize != -1) {
            e.setNewSize((int)globalSize);
        } else if (sizes.containsKey((Object)e.getWorldType())) {
            e.setNewSize((int)sizes.get((Object)e.getWorldType()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitBiomeGens(WorldTypeEvent.InitBiomeGens e) {
        e.getNewBiomeGens()[0] = new GenLayerReplacement(e.getNewBiomeGens()[0]);
        e.getNewBiomeGens()[1] = new GenLayerReplacement(e.getNewBiomeGens()[1]);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onReplaceVillageBlockID(BiomeEvent.GetVillageBlockID e) {
        if (e.getBiome() == null || e.getOriginal() == null) {
            return;
        }
        List list = (List)villageBlockReplacements.get(Biome.func_185362_a((Biome)e.getBiome()));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Pair fPair : list) {
            if (((IBlockState)fPair.getKey()).func_177230_c() != (e.getReplacement() == null ? e.getOriginal().func_177230_c() : e.getReplacement().func_177230_c())) continue;
            Integer meta = ((IBlockState)fPair.getKey()).func_177230_c().func_176201_c((IBlockState)fPair.getKey());
            boolean shouldDo = false;
            if (!shouldDo) {
                boolean bl = shouldDo = meta == (e.getReplacement() == null ? e.getOriginal().func_177230_c().func_176201_c(e.getOriginal()) : e.getReplacement().func_177230_c().func_176201_c(e.getReplacement()));
            }
            if (!shouldDo) continue;
            e.setReplacement((IBlockState)fPair.getValue());
            e.setResult(Event.Result.DENY);
            break;
        }
    }

    public static TIntObjectMap<List<Pair<IBlockState, IBlockState>>> getVillageBlockReplacements() {
        return villageBlockReplacements;
    }

    public static TIntObjectMap<List<String>> getDecorateTypes() {
        return decorateTypes;
    }

    public static TIntObjectMap<List<String>> getPopulateTypes() {
        return populateTypes;
    }

    public static TIntObjectMap<List<String>> getOreTypes() {
        return oreTypes;
    }

    public static Map<DecorateBiomeEvent.Decorate.EventType, TIntIntMap> getDecorationsPerChunk() {
        return decorationsPerChunk;
    }
}

