/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.integration;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.superckl.biometweaker.integration.IntegrationModule;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;

public class IntegrationManager
extends IntegrationModule {
    public static final IntegrationManager INSTANCE = new IntegrationManager();
    private static final Map<List<String>, String> modules = new HashMap<List<String>, String>();
    private final List<IntegrationModule> activeModules = new ArrayList<IntegrationModule>();

    private IntegrationManager() {
    }

    @Override
    public void preInit() {
        boolean noGo = false;
        for (Map.Entry<List<String>, String> entry : modules.entrySet()) {
            for (String mod : entry.getKey()) {
                if (Loader.isModLoaded((String)mod)) continue;
                noGo = true;
                break;
            }
            if (noGo) continue;
            try {
                IntegrationModule module = (IntegrationModule)Class.forName(entry.getValue()).newInstance();
                this.activeModules.add(module);
                LogHelper.info("Enabled " + module.getName() + " module.");
            }
            catch (Exception e) {
                LogHelper.error("Failed to instantiate integration module " + entry.getValue());
                e.printStackTrace();
            }
        }
        for (IntegrationModule module : this.activeModules) {
            module.preInit();
        }
    }

    @Override
    public void init() {
        for (IntegrationModule module : this.activeModules) {
            module.init();
        }
    }

    @Override
    public void postInit() {
        for (IntegrationModule module : this.activeModules) {
            module.postInit();
        }
    }

    @Override
    public String getName() {
        return "BiomeTweaker Integration Manager";
    }

    @Override
    public void addBiomeInfo(Biome biome, JsonObject obj) {
        for (IntegrationModule module : this.activeModules) {
            module.addBiomeInfo(biome, obj);
        }
    }

    public List<IntegrationModule> getActiveModules() {
        return this.activeModules;
    }

    static {
        modules.put(Arrays.asList("biomesoplenty"), "me.superckl.biometweaker.integration.bop.BOPIntegrationModule");
    }
}

