/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.data.IData;
import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IMutableItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import java.util.List;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="crafttweaker.item.IItemStack")
@ZenRegister
public interface IItemStack
extends IIngredient {
    @ZenGetter(value="definition")
    public IItemDefinition getDefinition();

    @ZenGetter(value="isItemBlock")
    default public boolean isItemBlock() {
        CraftTweakerAPI.logError("Class " + this.getClass().getCanonicalName() + " doesn't override IItemStack::isItemBlock!");
        return false;
    }

    @ZenGetter(value="name")
    public String getName();

    @ZenGetter(value="displayName")
    public String getDisplayName();

    @ZenSetter(value="displayName")
    public void setDisplayName(String var1);

    @ZenGetter(value="maxStackSize")
    public int getMaxStackSize();

    @ZenSetter(value="maxStackSize")
    public void setMaxStackSize(int var1);

    @ZenGetter(value="hardness")
    public float getBlockHardness();

    @ZenSetter(value="hardness")
    public void setBlockHardness(float var1);

    @ZenGetter(value="damage")
    public int getDamage();

    @ZenGetter(value="maxDamage")
    public int getMaxDamage();

    @ZenSetter(value="maxDamage")
    public void setMaxDamage(int var1);

    @ZenGetter(value="tag")
    public IData getTag();

    @ZenGetter(value="liquid")
    public ILiquidStack getLiquid();

    @Override
    @ZenMethod
    public IItemStack amount(int var1);

    @ZenOperator(value=OperatorType.MOD)
    public WeightedItemStack percent(float var1);

    @ZenMethod
    public WeightedItemStack weight(float var1);

    @ZenMethod
    public IIngredient anyDamage();

    @ZenMethod
    public IItemStack withDamage(int var1);

    @ZenOperator(value=OperatorType.MUL)
    @ZenMethod
    public IItemStack withAmount(int var1);

    @ZenMethod
    public IItemStack anyAmount();

    @ZenMethod
    default public IItemStack withTag(IData tag, @Optional(valueBoolean=true) boolean matchTagExact) {
        CraftTweakerAPI.logError("Default method IItemStack#WithTag is not overwritten in " + this.getClass() + " please report to the author!");
        return this.withTag(tag);
    }

    @ZenGetter(value="matchTagExact")
    default public boolean getMatchTagExact() {
        CraftTweakerAPI.logError("Default method IItemStack#getMatchTagExact is not overwritten in " + this.getClass() + " please report to the author!");
        return true;
    }

    @Deprecated
    public IItemStack withTag(IData var1);

    @ZenMethod
    public IItemStack withEmptyTag();

    @ZenMethod
    public IItemStack removeTag(String var1);

    @ZenMethod
    default public IItemStack updateTag(IData tagUpdate, @Optional(valueBoolean=true) boolean matchTagExact) {
        CraftTweakerAPI.logError("Default method IItemStack#updateTag is not overwritten in " + this.getClass() + " please report to the author!");
        return this.updateTag(tagUpdate);
    }

    @Deprecated
    public IItemStack updateTag(IData var1);

    @ZenCaster
    @ZenMethod
    public IBlock asBlock();

    @ZenGetter(value="ores")
    public List<IOreDictEntry> getOres();

    @ZenMethod
    public IItemStack withDisplayName(String var1);

    @ZenMethod
    public IItemStack withLore(String[] var1);

    @ZenGetter(value="toolClasses")
    public List<String> getToolClasses();

    @ZenGetter(value="itemEnchantability")
    public int getItemEnchantability();

    @ZenGetter(value="containerItem")
    public IItemStack getContainerItem();

    @ZenGetter(value="isBeaconPayment")
    public boolean isBeaconPayment();

    @ZenMethod
    public boolean canPlaceOn(IBlockDefinition var1);

    @ZenMethod
    public boolean canDestroy(IBlockDefinition var1);

    @ZenMethod
    public boolean canHarvestBlock(IBlockState var1);

    @ZenGetter(value="repairCost")
    public int getRepairCost();

    @ZenSetter(value="repairCost")
    public void setRepairCost(int var1);

    @ZenGetter(value="canEditBlocks")
    public boolean canEditBlocks();

    @ZenGetter(value="isOnItemFrame")
    public boolean isOnItemFrame();

    @ZenGetter(value="isEnchanted")
    public boolean isItemEnchanted();

    @ZenGetter(value="isDamaged")
    public boolean isItemDamaged();

    @ZenGetter(value="isDamageable")
    public boolean isDamageable();

    @ZenGetter(value="isStackable")
    public boolean isStackable();

    @ZenMethod
    public void addEnchantment(IEnchantment var1);

    @ZenMethod
    public boolean canApplyAtEnchantingTable(IEnchantmentDefinition var1);

    @ZenGetter(value="enchantments")
    public List<IEnchantment> getEnchantments();

    @ZenGetter(value="isEnchantable")
    public boolean isItemEnchantable();

    @ZenGetter(value="hasEffect")
    public boolean hasEffect();

    @ZenGetter(value="hasDisplayName")
    public boolean hasDisplayName();

    @ZenMethod
    public void clearCustomName();

    @ZenGetter(value="hasTag")
    public boolean hasTag();

    @ZenMethod
    public void damageItem(int var1, IEntity var2);

    @ZenGetter(value="metadata")
    public int getMetadata();

    @ZenGetter(value="hasSubtypes")
    public boolean getHasSubtypes();

    @ZenMethod
    public float getStrengthAgainstBlock(IBlockState var1);

    @ZenMethod
    public IItemStack splitStack(int var1);

    @ZenGetter(value="isEmpty")
    public boolean isEmpty();

    @ZenGetter(value="burnTime")
    public int getItemBurnTime();

    @ZenGetter(value="showsDurabilityBar")
    public boolean showsDurabilityBar();

    @ZenGetter(value="hasCustomEntity")
    public boolean hasCustomEntity();

    @ZenGetter(value="hasContainerItem")
    public boolean hasContainerItem();

    @ZenMethod
    public IEntityItem createEntityItem(IWorld var1, int var2, int var3, int var4);

    @ZenMethod
    default public IEntityItem createEntityItem(IWorld world, float x, float y, float z) {
        return this.createEntityItem(world, (int)x, (int)y, (int)z);
    }

    @ZenMethod
    public IEntityItem createEntityItem(IWorld var1, IBlockPos var2);

    @ZenMethod
    default public IMutableItemStack mutable() {
        CraftTweakerAPI.logError("Default method IItemStack#mutable is not overwritten in " + this.getClass() + " please report to the author!");
        return null;
    }

    @ZenGetter(value="isFood")
    default public boolean isFood() {
        return false;
    }

    @ZenGetter(value="saturation")
    default public float getSaturation() {
        return 0.0f;
    }

    @ZenGetter(value="healAmount")
    default public int getHealAmount() {
        return 0;
    }

    @ZenMethod
    default public int getHarvestLevel(String toolClass) {
        return -1;
    }

    @ZenMethod
    default public int getHarvestLevel(String toolClass, IPlayer player, IBlockState blockState) {
        return -1;
    }
}

